/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.TextFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.log4j.Appender;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezContainerLogAppender;
import org.apache.tez.common.io.NonSyncByteArrayOutputStream;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TezUtilsInternal {
    private static final Logger LOG = LoggerFactory.getLogger(TezUtilsInternal.class);
    private static final Pattern pattern = Pattern.compile("\\W");
    @InterfaceAudience.Private
    public static final int MAX_VERTEX_NAME_LENGTH = 40;

    public static DAGProtos.ConfigurationProto readUserSpecifiedTezConfiguration(String baseDir) throws IOException {
        File confPBFile = new File(baseDir, "tez-conf.pb");
        try (FileInputStream fis = new FileInputStream(confPBFile);){
            DAGProtos.ConfigurationProto configurationProto = DAGProtos.ConfigurationProto.parseFrom((InputStream)fis);
            return configurationProto;
        }
    }

    public static Configuration readTezConfigurationXml(InputStream is) throws IOException {
        Configuration configuration = new Configuration();
        if (is != null) {
            configuration.addResource(is);
        }
        return configuration;
    }

    /*
     * Exception decompiling
     */
    public static DAGProtos.ConfigurationProto loadConfProtoFromText() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addUserSpecifiedTezConfiguration(Configuration conf, List<DAGProtos.PlanKeyValuePair> kvPairList) {
        if (kvPairList != null && !kvPairList.isEmpty()) {
            for (DAGProtos.PlanKeyValuePair kvPair : kvPairList) {
                conf.set(kvPair.getKey(), kvPair.getValue());
            }
        }
    }

    public static byte[] compressBytes(byte[] inBytes) throws IOException {
        StopWatch sw = new StopWatch().start();
        byte[] compressed = TezUtilsInternal.compressBytesInflateDeflate(inBytes);
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("UncompressedSize: " + inBytes.length + ", CompressedSize: " + compressed.length + ", CompressTime: " + sw.now(TimeUnit.MILLISECONDS));
        }
        return compressed;
    }

    public static byte[] uncompressBytes(byte[] inBytes) throws IOException {
        StopWatch sw = new StopWatch().start();
        byte[] uncompressed = TezUtilsInternal.uncompressBytesInflateDeflate(inBytes);
        sw.stop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("CompressedSize: " + inBytes.length + ", UncompressedSize: " + uncompressed.length + ", UncompressTimeTaken: " + sw.now(TimeUnit.MILLISECONDS));
        }
        return uncompressed;
    }

    private static byte[] compressBytesInflateDeflate(byte[] inBytes) {
        Deflater deflater = new Deflater(1);
        deflater.setInput(inBytes);
        NonSyncByteArrayOutputStream bos = new NonSyncByteArrayOutputStream(inBytes.length);
        deflater.finish();
        byte[] buffer = new byte[8192];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            bos.write(buffer, 0, count);
        }
        byte[] output = bos.toByteArray();
        return output;
    }

    private static byte[] uncompressBytesInflateDeflate(byte[] inBytes) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(inBytes);
        NonSyncByteArrayOutputStream bos = new NonSyncByteArrayOutputStream(inBytes.length);
        byte[] buffer = new byte[8192];
        while (!inflater.finished()) {
            int count;
            try {
                count = inflater.inflate(buffer);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
            bos.write(buffer, 0, count);
        }
        byte[] output = bos.toByteArray();
        return output;
    }

    @InterfaceAudience.Private
    public static String cleanVertexName(String vertexName) {
        return TezUtilsInternal.sanitizeString(vertexName).substring(0, vertexName.length() > 40 ? 40 : vertexName.length());
    }

    private static String sanitizeString(String srcString) {
        Matcher matcher = pattern.matcher(srcString);
        String res = matcher.replaceAll("_");
        return res;
    }

    public static void updateLoggers(String addend) throws FileNotFoundException {
        LOG.info("Redirecting log file based on addend: " + addend);
        Appender appender = org.apache.log4j.Logger.getRootLogger().getAppender("CLA");
        if (appender != null) {
            if (appender instanceof TezContainerLogAppender) {
                TezContainerLogAppender claAppender = (TezContainerLogAppender)appender;
                claAppender.setLogFileName(TezUtilsInternal.constructLogFileName("syslog", addend));
                claAppender.activateOptions();
            } else {
                LOG.warn("Appender is a " + appender.getClass() + "; require an instance of " + TezContainerLogAppender.class.getName() + " to reconfigure the logger output");
            }
        } else {
            LOG.warn("Not configured with appender named: CLA. Cannot reconfigure logger output");
        }
    }

    private static String constructLogFileName(String base, String addend) {
        if (addend == null || addend.isEmpty()) {
            return base;
        }
        return base + "_" + addend;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        if (bytes == null) {
            return new BitSet();
        }
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits) {
        if (bits == null) {
            return null;
        }
        byte[] bytes = new byte[(bits.length() + 7) / 8];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static String convertDagPlanToString(DAGProtos.DAGPlan dagPlan) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : dagPlan.getAllFields().entrySet()) {
            if (((Descriptors.FieldDescriptor)entry.getKey()).getNumber() != 5) {
                TextFormat.printField((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)entry.getKey()), entry.getValue(), (Appendable)sb);
                continue;
            }
            Credentials credentials = DagTypeConverters.convertByteStringToCredentials((ByteString)dagPlan.getCredentialsBinary());
            TextFormat.printField((Descriptors.FieldDescriptor)((Descriptors.FieldDescriptor)entry.getKey()), (Object)ByteString.copyFrom((byte[])TezCommonUtils.getCredentialsInfo((Credentials)credentials, (String)"dag").getBytes(Charset.forName("UTF-8"))), (Appendable)sb);
        }
        return sb.toString();
    }

    public static TaskAttemptTerminationCause fromTaskAttemptEndReason(TaskAttemptEndReason taskAttemptEndReason) {
        if (taskAttemptEndReason == null) {
            return null;
        }
        switch (taskAttemptEndReason) {
            case COMMUNICATION_ERROR: {
                return TaskAttemptTerminationCause.COMMUNICATION_ERROR;
            }
            case EXECUTOR_BUSY: {
                return TaskAttemptTerminationCause.SERVICE_BUSY;
            }
            case INTERNAL_PREEMPTION: {
                return TaskAttemptTerminationCause.INTERNAL_PREEMPTION;
            }
            case EXTERNAL_PREEMPTION: {
                return TaskAttemptTerminationCause.EXTERNAL_PREEMPTION;
            }
            case APPLICATION_ERROR: {
                return TaskAttemptTerminationCause.APPLICATION_ERROR;
            }
            case FRAMEWORK_ERROR: {
                return TaskAttemptTerminationCause.FRAMEWORK_ERROR;
            }
            case NODE_FAILED: {
                return TaskAttemptTerminationCause.NODE_FAILED;
            }
            case CONTAINER_EXITED: {
                return TaskAttemptTerminationCause.CONTAINER_EXITED;
            }
            case OTHER: {
                return TaskAttemptTerminationCause.UNKNOWN_ERROR;
            }
        }
        return TaskAttemptTerminationCause.UNKNOWN_ERROR;
    }

    public static TaskAttemptEndReason toTaskAttemptEndReason(TaskAttemptTerminationCause cause) {
        if (cause == null) {
            return null;
        }
        switch (cause) {
            case COMMUNICATION_ERROR: {
                return TaskAttemptEndReason.COMMUNICATION_ERROR;
            }
            case SERVICE_BUSY: {
                return TaskAttemptEndReason.EXECUTOR_BUSY;
            }
            case INTERNAL_PREEMPTION: {
                return TaskAttemptEndReason.INTERNAL_PREEMPTION;
            }
            case EXTERNAL_PREEMPTION: {
                return TaskAttemptEndReason.EXTERNAL_PREEMPTION;
            }
            case APPLICATION_ERROR: {
                return TaskAttemptEndReason.APPLICATION_ERROR;
            }
            case FRAMEWORK_ERROR: {
                return TaskAttemptEndReason.FRAMEWORK_ERROR;
            }
            case NODE_FAILED: {
                return TaskAttemptEndReason.NODE_FAILED;
            }
            case CONTAINER_EXITED: {
                return TaskAttemptEndReason.CONTAINER_EXITED;
            }
        }
        return TaskAttemptEndReason.OTHER;
    }

    public static <T extends Enum<T>> Set<T> getEnums(Configuration conf, String confName, Class<T> enumType, String defaultValues) {
        String[] names = conf.getStrings(confName);
        if (names == null) {
            names = StringUtils.getStrings((String)defaultValues);
        }
        if (names == null) {
            return null;
        }
        HashSet<T> enums = new HashSet<T>();
        for (String name : names) {
            enums.add(Enum.valueOf(enumType, name));
        }
        return enums;
    }

    @InterfaceAudience.Private
    public static void setHadoopCallerContext(HadoopShim hadoopShim, TezTaskAttemptID attemptID) {
        hadoopShim.setHadoopCallerContext("tez_ta:" + attemptID.toString());
    }

    @InterfaceAudience.Private
    public static void setHadoopCallerContext(HadoopShim hadoopShim, TezVertexID vertexID) {
        hadoopShim.setHadoopCallerContext("tez_v:" + vertexID.toString());
    }

    @InterfaceAudience.Private
    public static void setHadoopCallerContext(HadoopShim hadoopShim, TezDAGID dagID) {
        hadoopShim.setHadoopCallerContext("tez_dag:" + dagID.toString());
    }

    @InterfaceAudience.Private
    public static void setHadoopCallerContext(HadoopShim hadoopShim, ApplicationId appID) {
        hadoopShim.setHadoopCallerContext("tez_app:" + appID.toString());
    }

    @InterfaceAudience.Private
    public static void setSecurityUtilConfigration(Logger log, Configuration conf) {
        Class<SecurityUtil> clz = SecurityUtil.class;
        try {
            Method method = clz.getMethod("setConfiguration", Configuration.class);
            method.invoke(null, conf);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            log.warn("Error invoking SecurityUtil.setConfiguration: ", (Throwable)e);
            throw new TezUncheckedException("Error invoking SecurityUtil.setConfiguration", (Throwable)e);
        }
    }
}

