/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.split.SplitLocationProvider;
import org.apache.hadoop.mapreduce.split.SplitSizeEstimator;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.hadoop.mapreduce.split.TezMapReduceSplitsGrouper;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TezGroupedSplitsInputFormat<K, V>
extends InputFormat<K, V>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(TezGroupedSplitsInputFormat.class);
    InputFormat<K, V> wrappedInputFormat;
    int desiredNumSplits = 0;
    Configuration conf;
    SplitSizeEstimator estimator;
    SplitLocationProvider locationProvider;

    public void setInputFormat(InputFormat<K, V> wrappedInputFormat) {
        this.wrappedInputFormat = wrappedInputFormat;
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrappedInputFormat: " + wrappedInputFormat.getClass().getName());
        }
    }

    public void setDesiredNumberOfSplits(int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0);
        this.desiredNumSplits = num;
        if (LOG.isDebugEnabled()) {
            LOG.debug("desiredNumSplits: " + this.desiredNumSplits);
        }
    }

    public void setSplitSizeEstimator(SplitSizeEstimator estimator) {
        Preconditions.checkArgument((estimator != null ? 1 : 0) != 0);
        this.estimator = estimator;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split size estimator : " + estimator);
        }
    }

    public void setSplitLocationProvider(SplitLocationProvider locationProvider) {
        Preconditions.checkArgument((locationProvider != null ? 1 : 0) != 0);
        this.locationProvider = locationProvider;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split location provider : " + locationProvider);
        }
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        List originalSplits = this.wrappedInputFormat.getSplits(context);
        TezMapReduceSplitsGrouper grouper = new TezMapReduceSplitsGrouper();
        String wrappedInputFormatName = this.wrappedInputFormat.getClass().getName();
        return grouper.getGroupedSplits(this.conf, originalSplits, this.desiredNumSplits, wrappedInputFormatName, this.estimator, this.locationProvider);
    }

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        TezGroupedSplit groupedSplit = (TezGroupedSplit)split;
        try {
            this.initInputFormatFromSplit(groupedSplit);
        }
        catch (TezException e) {
            throw new IOException(e);
        }
        return new TezGroupedSplitsRecordReader(groupedSplit, context);
    }

    void initInputFormatFromSplit(TezGroupedSplit split) throws TezException {
        if (this.wrappedInputFormat == null) {
            Class<?> clazz = TezGroupedSplitsInputFormat.getClassFromName(split.wrappedInputFormatName);
            try {
                this.wrappedInputFormat = (InputFormat)org.apache.hadoop.util.ReflectionUtils.newInstance(clazz, (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new TezException((Throwable)e);
            }
        }
    }

    static Class<?> getClassFromName(String name) throws TezException {
        return ReflectionUtils.getClazz((String)name);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public class TezGroupedSplitsRecordReader
    extends RecordReader<K, V> {
        TezGroupedSplit groupedSplit;
        TaskAttemptContext context;
        int idx = 0;
        long progress;
        RecordReader<K, V> curReader;

        public TezGroupedSplitsRecordReader(TezGroupedSplit split, TaskAttemptContext context) throws IOException {
            this.groupedSplit = split;
            this.context = context;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            if (this.groupedSplit != split) {
                throw new TezUncheckedException("Splits dont match");
            }
            if (this.context != context) {
                throw new TezUncheckedException("Contexts dont match");
            }
            this.initNextRecordReader();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            while (this.curReader == null || !this.curReader.nextKeyValue()) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.curReader.getCurrentKey();
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.curReader.getCurrentValue();
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    try {
                        this.progress += this.groupedSplit.wrappedSplits.get(this.idx - 1).getLength();
                    }
                    catch (InterruptedException e) {
                        throw new TezUncheckedException((Throwable)e);
                    }
                }
            }
            if (this.idx == this.groupedSplit.wrappedSplits.size()) {
                return false;
            }
            try {
                this.curReader = TezGroupedSplitsInputFormat.this.wrappedInputFormat.createRecordReader(this.groupedSplit.wrappedSplits.get(this.idx), this.context);
                this.curReader.initialize(this.groupedSplit.wrappedSplits.get(this.idx), this.context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.idx;
            return true;
        }

        public float getProgress() throws IOException, InterruptedException {
            long subprogress = 0L;
            if (null != this.curReader) {
                subprogress = (long)(this.curReader.getProgress() * (float)this.groupedSplit.wrappedSplits.get(this.idx - 1).getLength());
            }
            return Math.min(1.0f, (float)(this.progress + subprogress) / (float)this.groupedSplit.getLength());
        }
    }
}

