/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce;

import com.google.common.base.Preconditions;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class SumProcessor
extends SimpleMRProcessor {
    static String OUTPUT = "Output";
    static String TOKENIZER = "Tokenizer";

    public SumProcessor(ProcessorContext context) {
        super(context);
    }

    public void run() throws Exception {
        Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
        KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(OUTPUT)).getWriter();
        KeyValuesReader kvReader = (KeyValuesReader)((LogicalInput)this.getInputs().get(TOKENIZER)).getReader();
        while (kvReader.next()) {
            Text word = (Text)kvReader.getCurrentKey();
            int sum = 0;
            for (Object value : kvReader.getCurrentValues()) {
                sum += ((IntWritable)value).get();
            }
            kvWriter.write((Object)word, (Object)new IntWritable(sum));
        }
    }
}

