/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.lib;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.mapreduce.hadoop.mapred.MRReporter;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.runtime.api.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRReaderMapred
extends MRReader {
    private static final Logger LOG = LoggerFactory.getLogger(MRReaderMapred.class);
    Object key;
    Object value;
    private final JobConf jobConf;
    private final TezCounters tezCounters;
    private final TezCounter inputRecordCounter;
    private final InputFormat inputFormat;
    protected InputSplit inputSplit;
    protected RecordReader recordReader;
    private Configuration incrementalConf;
    private boolean setupComplete = false;

    public MRReaderMapred(JobConf jobConf, TezCounters tezCounters, TezCounter inputRecordCounter, InputContext context) throws IOException {
        this(jobConf, null, tezCounters, inputRecordCounter, context);
    }

    public MRReaderMapred(JobConf jobConf, InputSplit inputSplit, TezCounters tezCounters, TezCounter inputRecordCounter, InputContext context) throws IOException {
        super(context);
        this.jobConf = jobConf;
        this.tezCounters = tezCounters;
        this.inputRecordCounter = inputRecordCounter;
        this.inputFormat = this.jobConf.getInputFormat();
        if (inputSplit != null) {
            this.inputSplit = inputSplit;
            this.setupOldRecordReader();
        }
    }

    @Override
    public void setSplit(Object inputSplit) throws IOException {
        this.inputSplit = (InputSplit)inputSplit;
        this.setupOldRecordReader();
    }

    @Override
    public boolean isSetup() {
        return this.setupComplete;
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.setupComplete ? this.recordReader.getProgress() : 0.0f;
    }

    @Override
    public void close() throws IOException {
        if (this.setupComplete) {
            this.recordReader.close();
        }
    }

    @Override
    public Object getSplit() {
        return this.inputSplit;
    }

    @Override
    public Object getRecordReader() {
        return this.recordReader;
    }

    public boolean next() throws IOException {
        boolean hasNext = this.recordReader.next(this.key, this.value);
        if (hasNext) {
            this.inputRecordCounter.increment(1L);
            this.notifyProgress();
        } else {
            this.hasCompletedProcessing();
            this.completedProcessing = true;
            this.notifyDone();
        }
        return hasNext;
    }

    public Object getCurrentKey() throws IOException {
        return this.key;
    }

    public Object getCurrentValue() throws IOException {
        return this.value;
    }

    public Configuration getConfigUpdates() {
        if (this.incrementalConf != null) {
            return new Configuration(this.incrementalConf);
        }
        return null;
    }

    private void setupOldRecordReader() throws IOException {
        Objects.requireNonNull(this.inputSplit, "Input split hasn't yet been setup");
        this.recordReader = this.inputFormat.getRecordReader(this.inputSplit, this.jobConf, (Reporter)new MRReporter(this.tezCounters, this.inputSplit));
        this.setIncrementalConfigParams(this.inputSplit);
        this.key = this.recordReader.createKey();
        this.value = this.recordReader.createValue();
        this.setupComplete = true;
    }

    private void setIncrementalConfigParams(InputSplit inputSplit) {
        if (inputSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)inputSplit;
            this.incrementalConf = new Configuration(false);
            this.incrementalConf.set("mapreduce.map.input.file", fileSplit.getPath().toString());
            this.incrementalConf.setLong("mapreduce.map.input.start", fileSplit.getStart());
            this.incrementalConf.setLong("mapreduce.map.input.length", fileSplit.getLength());
        }
        LOG.info("Processing split: " + inputSplit);
    }
}

