/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.grouper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.mapreduce.grouper.GroupedSplitContainer;
import org.apache.tez.mapreduce.grouper.SplitContainer;
import org.apache.tez.mapreduce.grouper.SplitLocationProviderWrapper;
import org.apache.tez.mapreduce.grouper.SplitSizeEstimatorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TezSplitGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(TezSplitGrouper.class);
    public static final String TEZ_GROUPING_SPLIT_COUNT = "tez.grouping.split-count";
    public static final String TEZ_GROUPING_SPLIT_BY_LENGTH = "tez.grouping.by-length";
    public static final boolean TEZ_GROUPING_SPLIT_BY_LENGTH_DEFAULT = true;
    public static final String TEZ_GROUPING_SPLIT_BY_COUNT = "tez.grouping.by-count";
    public static final boolean TEZ_GROUPING_SPLIT_BY_COUNT_DEFAULT = false;
    public static final String TEZ_GROUPING_SPLIT_WAVES = "tez.grouping.split-waves";
    public static final float TEZ_GROUPING_SPLIT_WAVES_DEFAULT = 1.7f;
    public static final String TEZ_GROUPING_SPLIT_MAX_SIZE = "tez.grouping.max-size";
    public static final long TEZ_GROUPING_SPLIT_MAX_SIZE_DEFAULT = 0x40000000L;
    public static final String TEZ_GROUPING_SPLIT_MIN_SIZE = "tez.grouping.min-size";
    public static final long TEZ_GROUPING_SPLIT_MIN_SIZE_DEFAULT = 0x3200000L;
    public static final String TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION = "tez.grouping.rack-split-reduction";
    public static final float TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION_DEFAULT = 0.75f;
    public static final String TEZ_GROUPING_REPEATABLE = "tez.grouping.repeatable";
    public static final boolean TEZ_GROUPING_REPEATABLE_DEFAULT = true;
    public static final String TEZ_GROUPING_NODE_LOCAL_ONLY = "tez.grouping.node.local.only";
    public static final boolean TEZ_GROUPING_NODE_LOCAL_ONLY_DEFAULT = false;
    private static final SplitSizeEstimatorWrapper DEFAULT_SPLIT_ESTIMATOR = new DefaultSplitSizeEstimatorWrapper();
    private static final SplitLocationProviderWrapper DEFAULT_SPLIT_LOCATION_PROVIDER = new DefaultSplitLocationProvider();

    Map<String, LocationHolder> createLocationsMap(Configuration conf) {
        if (conf.getBoolean(TEZ_GROUPING_REPEATABLE, true)) {
            return new TreeMap<String, LocationHolder>();
        }
        return new HashMap<String, LocationHolder>();
    }

    /*
     * WARNING - void declaration
     */
    public List<GroupedSplitContainer> getGroupedSplits(Configuration conf, List<SplitContainer> originalSplits, int desiredNumSplits, String wrappedInputFormatName, SplitSizeEstimatorWrapper estimator, SplitLocationProviderWrapper locationProvider) throws IOException, InterruptedException {
        LOG.info("Grouping splits in Tez");
        Preconditions.checkArgument((originalSplits != null ? 1 : 0) != 0, (Object)"Splits must be specified");
        int configNumSplits = conf.getInt(TEZ_GROUPING_SPLIT_COUNT, 0);
        if (configNumSplits > 0) {
            desiredNumSplits = configNumSplits;
            LOG.info("Desired numSplits overridden by config to: " + desiredNumSplits);
        }
        if (estimator == null) {
            estimator = DEFAULT_SPLIT_ESTIMATOR;
        }
        if (locationProvider == null) {
            locationProvider = DEFAULT_SPLIT_LOCATION_PROVIDER;
        }
        ArrayList<GroupedSplitContainer> groupedSplits = null;
        String emptyLocation = "EmptyLocation";
        String localhost = "localhost";
        String[] emptyLocations = new String[]{emptyLocation};
        groupedSplits = new ArrayList<GroupedSplitContainer>(desiredNumSplits);
        boolean allSplitsHaveLocalhost = true;
        long totalLength = 0L;
        Map<String, LocationHolder> distinctLocations = this.createLocationsMap(conf);
        for (SplitContainer split : originalSplits) {
            totalLength += estimator.getEstimatedSize(split);
            String[] locations = locationProvider.getPreferredLocations(split);
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
                allSplitsHaveLocalhost = false;
            }
            for (String string : locations) {
                void var22_31;
                if (string == null) {
                    String string2 = emptyLocation;
                    allSplitsHaveLocalhost = false;
                }
                if (!var22_31.equalsIgnoreCase(localhost)) {
                    allSplitsHaveLocalhost = false;
                }
                distinctLocations.put((String)var22_31, null);
            }
        }
        if (configNumSplits <= 0 && originalSplits.size() != 0) {
            int newDesiredNumSplits;
            long minLengthPerGroup;
            int splitCount = desiredNumSplits > 0 ? desiredNumSplits : originalSplits.size();
            long lengthPerGroup = totalLength / (long)splitCount;
            long maxLengthPerGroup = conf.getLong(TEZ_GROUPING_SPLIT_MAX_SIZE, 0x40000000L);
            if (maxLengthPerGroup < (minLengthPerGroup = conf.getLong(TEZ_GROUPING_SPLIT_MIN_SIZE, 0x3200000L)) || minLengthPerGroup <= 0L) {
                throw new TezUncheckedException("Invalid max/min group lengths. Required min>0, max>=min.  max: " + maxLengthPerGroup + " min: " + minLengthPerGroup);
            }
            if (lengthPerGroup > maxLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / maxLengthPerGroup) + 1;
                LOG.info("Desired splits: " + desiredNumSplits + " too small. " + " Desired splitLength: " + lengthPerGroup + " Max splitLength: " + maxLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.size());
                desiredNumSplits = newDesiredNumSplits;
            } else if (lengthPerGroup < minLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / minLengthPerGroup) + 1;
                if (!allSplitsHaveLocalhost) {
                    desiredNumSplits = newDesiredNumSplits;
                }
                LOG.info("Desired splits: " + desiredNumSplits + " too large. " + " Desired splitLength: " + lengthPerGroup + " Min splitLength: " + minLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Final desired splits: " + desiredNumSplits + " All splits have localhost: " + allSplitsHaveLocalhost + " Total length: " + totalLength + " Original splits: " + originalSplits.size());
            }
        }
        if (desiredNumSplits == 0 || originalSplits.size() == 0 || desiredNumSplits >= originalSplits.size()) {
            LOG.info("Using original number of splits: " + originalSplits.size() + " desired splits: " + desiredNumSplits);
            groupedSplits = new ArrayList(originalSplits.size());
            for (SplitContainer split : originalSplits) {
                GroupedSplitContainer newSplit = new GroupedSplitContainer(1, wrappedInputFormatName, this.cleanupLocations(locationProvider.getPreferredLocations(split)), null);
                newSplit.addSplit(split);
                groupedSplits.add(newSplit);
            }
            return groupedSplits;
        }
        long lengthPerGroup = totalLength / (long)desiredNumSplits;
        int numNodeLocations = distinctLocations.size();
        int numSplitsPerLocation = originalSplits.size() / numNodeLocations;
        int numSplitsInGroup = originalSplits.size() / desiredNumSplits;
        for (String string : distinctLocations.keySet()) {
            distinctLocations.put(string, new LocationHolder(numSplitsPerLocation + 1));
        }
        HashSet<String> locSet = new HashSet<String>();
        for (SplitContainer split : originalSplits) {
            locSet.clear();
            String[] locations = locationProvider.getPreferredLocations(split);
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                if (location == null) {
                    location = emptyLocation;
                }
                locSet.add(location);
            }
            for (String location : locSet) {
                LocationHolder holder = distinctLocations.get(location);
                holder.splits.add(split);
            }
        }
        boolean bl = conf.getBoolean(TEZ_GROUPING_SPLIT_BY_LENGTH, true);
        boolean groupByCount = conf.getBoolean(TEZ_GROUPING_SPLIT_BY_COUNT, false);
        boolean nodeLocalOnly = conf.getBoolean(TEZ_GROUPING_NODE_LOCAL_ONLY, false);
        if (!bl && !groupByCount) {
            throw new TezUncheckedException("None of the grouping parameters are true: tez.grouping.by-length, tez.grouping.by-count");
        }
        LOG.info("Desired numSplits: " + desiredNumSplits + " lengthPerGroup: " + lengthPerGroup + " numLocations: " + numNodeLocations + " numSplitsPerLocation: " + numSplitsPerLocation + " numSplitsInGroup: " + numSplitsInGroup + " totalLength: " + totalLength + " numOriginalSplits: " + originalSplits.size() + " . Grouping by length: " + bl + " count: " + groupByCount + " nodeLocalOnly: " + nodeLocalOnly);
        int splitsProcessed = 0;
        ArrayList<SplitContainer> group = new ArrayList<SplitContainer>(numSplitsInGroup);
        HashSet<String> groupLocationSet = new HashSet<String>(10);
        boolean allowSmallGroups = false;
        boolean doingRackLocal = false;
        int iterations = 0;
        while (splitsProcessed < originalSplits.size()) {
            ++iterations;
            int numFullGroupsCreated = 0;
            for (Map.Entry<String, LocationHolder> entry : distinctLocations.entrySet()) {
                group.clear();
                groupLocationSet.clear();
                String location = entry.getKey();
                LocationHolder locationHolder = entry.getValue();
                SplitContainer splitContainer = locationHolder.getUnprocessedHeadSplit();
                if (splitContainer == null) continue;
                int oldHeadIndex = locationHolder.headIndex;
                long groupLength = 0L;
                int groupNumSplits = 0;
                do {
                    group.add(splitContainer);
                    locationHolder.incrementHeadIndex();
                } while ((splitContainer = locationHolder.getUnprocessedHeadSplit()) != null && (!bl || (groupLength += estimator.getEstimatedSize(splitContainer)) + estimator.getEstimatedSize(splitContainer) <= lengthPerGroup) && (!groupByCount || ++groupNumSplits + 1 <= numSplitsInGroup));
                if (!(!locationHolder.isEmpty() || allowSmallGroups || bl && groupLength >= lengthPerGroup / 2L || groupByCount && groupNumSplits >= numSplitsInGroup / 2)) {
                    locationHolder.headIndex = oldHeadIndex;
                    continue;
                }
                ++numFullGroupsCreated;
                Object groupLocation = new String[]{location};
                if (location == emptyLocation) {
                    groupLocation = null;
                } else if (doingRackLocal) {
                    for (SplitContainer splitH : group) {
                        String[] locations = locationProvider.getPreferredLocations(splitH);
                        if (locations == null) continue;
                        for (String loc : locations) {
                            if (loc == null) continue;
                            groupLocationSet.add(loc);
                        }
                    }
                    groupLocation = groupLocationSet.toArray((T[])groupLocation);
                }
                GroupedSplitContainer groupedSplit = new GroupedSplitContainer(group.size(), wrappedInputFormatName, (String[])groupLocation, doingRackLocal && location != emptyLocation ? location : null);
                for (SplitContainer groupedSplitContainer : group) {
                    groupedSplit.addSplit(groupedSplitContainer);
                    Preconditions.checkState((!groupedSplitContainer.isProcessed() ? 1 : 0) != 0, (Object)("Duplicates in grouping at location: " + (String)location));
                    groupedSplitContainer.setIsProcessed(true);
                    ++splitsProcessed;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Grouped " + group.size() + " length: " + groupedSplit.getLength() + " split at: " + (String)location);
                }
                groupedSplits.add(groupedSplit);
            }
            if (!doingRackLocal && numFullGroupsCreated < 1) {
                if (nodeLocalOnly && !allowSmallGroups) {
                    LOG.info("Allowing small groups early after attempting to create full groups at iteration: {}, groupsCreatedSoFar={}", (Object)iterations, (Object)groupedSplits.size());
                    allowSmallGroups = true;
                    continue;
                }
                doingRackLocal = true;
                int numRemainingSplits = originalSplits.size() - splitsProcessed;
                HashSet<SplitContainer> remainingSplits = new HashSet<SplitContainer>(numRemainingSplits);
                for (Map.Entry entry : distinctLocations.entrySet()) {
                    LocationHolder locHolder = (LocationHolder)entry.getValue();
                    while (!locHolder.isEmpty()) {
                        SplitContainer splitHolder = locHolder.getUnprocessedHeadSplit();
                        if (splitHolder == null) continue;
                        remainingSplits.add(splitHolder);
                        locHolder.incrementHeadIndex();
                    }
                }
                if (remainingSplits.size() != numRemainingSplits) {
                    throw new TezUncheckedException("Expected: " + numRemainingSplits + " got: " + remainingSplits.size());
                }
                RackResolver.init((Configuration)conf);
                HashMap<String, String> locToRackMap = new HashMap<String, String>(distinctLocations.size());
                Map<String, LocationHolder> map = this.createLocationsMap(conf);
                for (String location : distinctLocations.keySet()) {
                    String rack = emptyLocation;
                    if (location != emptyLocation) {
                        rack = RackResolver.resolve((String)location).getNetworkLocation();
                    }
                    locToRackMap.put(location, rack);
                    if (map.get(rack) != null) continue;
                    map.put(rack, new LocationHolder(numRemainingSplits));
                }
                distinctLocations.clear();
                HashSet rackSet = new HashSet(map.size());
                int numRackSplitsToGroup = remainingSplits.size();
                for (SplitContainer split : originalSplits) {
                    if (numRackSplitsToGroup == 0) break;
                    if (!remainingSplits.contains(split)) continue;
                    --numRackSplitsToGroup;
                    rackSet.clear();
                    String[] locations = locationProvider.getPreferredLocations(split);
                    if (locations == null || locations.length == 0) {
                        locations = emptyLocations;
                    }
                    for (String location : locations) {
                        if (location == null) {
                            location = emptyLocation;
                        }
                        rackSet.add(locToRackMap.get(location));
                    }
                    for (String rack : rackSet) {
                        map.get((Object)rack).splits.add(split);
                    }
                }
                remainingSplits.clear();
                distinctLocations = map;
                float rackSplitReduction = conf.getFloat(TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION, 0.75f);
                if (rackSplitReduction > 0.0f) {
                    long newLengthPerGroup = (long)((float)lengthPerGroup * rackSplitReduction);
                    int newNumSplitsInGroup = (int)((float)numSplitsInGroup * rackSplitReduction);
                    if (newLengthPerGroup > 0L) {
                        lengthPerGroup = newLengthPerGroup;
                    }
                    if (newNumSplitsInGroup > 0) {
                        numSplitsInGroup = newNumSplitsInGroup;
                    }
                }
                LOG.info("Doing rack local after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplits.size() + " lengthPerGroup: " + lengthPerGroup + " numSplitsInGroup: " + numSplitsInGroup);
                continue;
            }
            if (!allowSmallGroups && numFullGroupsCreated <= numNodeLocations / 10) {
                allowSmallGroups = true;
                LOG.info("Allowing small groups after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplits.size());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplits.size());
        }
        LOG.info("Number of splits desired: " + desiredNumSplits + " created: " + groupedSplits.size() + " splitsProcessed: " + splitsProcessed);
        return groupedSplits;
    }

    private String[] cleanupLocations(String[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        boolean nullLocationFound = false;
        for (String location : locations) {
            if (location != null) continue;
            nullLocationFound = true;
            break;
        }
        if (!nullLocationFound) {
            return locations;
        }
        LinkedList<String> newLocations = new LinkedList<String>();
        for (String location : locations) {
            if (location == null) continue;
            newLocations.add(location);
        }
        if (newLocations.size() == 0) {
            return null;
        }
        return newLocations.toArray(new String[newLocations.size()]);
    }

    public static TezMRSplitsGrouperConfigBuilder newConfigBuilder(Configuration conf) {
        return new TezMRSplitsGrouperConfigBuilder(conf);
    }

    public static final class TezMRSplitsGrouperConfigBuilder {
        private final Configuration conf;

        private TezMRSplitsGrouperConfigBuilder(@Nullable Configuration conf) {
            if (conf == null) {
                conf = new Configuration(false);
            }
            this.conf = conf;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitCount(int count) {
            this.conf.setInt(TezSplitGrouper.TEZ_GROUPING_SPLIT_COUNT, count);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitByCount(boolean enabled) {
            this.conf.setBoolean(TezSplitGrouper.TEZ_GROUPING_SPLIT_BY_COUNT, enabled);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitByLength(boolean enabled) {
            this.conf.setBoolean(TezSplitGrouper.TEZ_GROUPING_SPLIT_BY_LENGTH, enabled);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupSplitWaves(float multiplier) {
            this.conf.setFloat(TezSplitGrouper.TEZ_GROUPING_SPLIT_WAVES, multiplier);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupingRackSplitSizeReduction(float rackSplitSizeReduction) {
            this.conf.setFloat(TezSplitGrouper.TEZ_GROUPING_RACK_SPLIT_SIZE_REDUCTION, rackSplitSizeReduction);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setNodeLocalGroupsOnly(boolean nodeLocalGroupsOnly) {
            this.conf.setBoolean(TezSplitGrouper.TEZ_GROUPING_NODE_LOCAL_ONLY, nodeLocalGroupsOnly);
            return this;
        }

        public TezMRSplitsGrouperConfigBuilder setGroupingSplitSize(long lowerBound, long upperBound) {
            this.conf.setLong(TezSplitGrouper.TEZ_GROUPING_SPLIT_MIN_SIZE, lowerBound);
            this.conf.setLong(TezSplitGrouper.TEZ_GROUPING_SPLIT_MAX_SIZE, upperBound);
            return this;
        }

        public Configuration build() {
            return this.conf;
        }
    }

    static final class DefaultSplitLocationProvider
    implements SplitLocationProviderWrapper {
        DefaultSplitLocationProvider() {
        }

        @Override
        public String[] getPreferredLocations(SplitContainer splitContainer) throws IOException, InterruptedException {
            return splitContainer.getPreferredLocations();
        }
    }

    static final class DefaultSplitSizeEstimatorWrapper
    implements SplitSizeEstimatorWrapper {
        DefaultSplitSizeEstimatorWrapper() {
        }

        @Override
        public long getEstimatedSize(SplitContainer splitContainer) throws IOException, InterruptedException {
            return splitContainer.getLength();
        }
    }

    static class LocationHolder {
        List<SplitContainer> splits;
        int headIndex = 0;

        LocationHolder(int capacity) {
            this.splits = new ArrayList<SplitContainer>(capacity);
        }

        boolean isEmpty() {
            return this.headIndex == this.splits.size();
        }

        SplitContainer getUnprocessedHeadSplit() {
            while (!this.isEmpty()) {
                SplitContainer holder = this.splits.get(this.headIndex);
                if (!holder.isProcessed()) {
                    return holder;
                }
                this.incrementHeadIndex();
            }
            return null;
        }

        void incrementHeadIndex() {
            ++this.headIndex;
        }
    }
}

