/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.tez.common.TezLocalResource;
import org.apache.tez.runtime.api.impl.TaskSpec;

public class ContainerTask
implements Writable {
    TaskSpec taskSpec;
    boolean shouldDie;
    private Map<String, TezLocalResource> additionalResources;
    private Credentials credentials;
    private boolean credentialsChanged;

    public ContainerTask() {
    }

    public ContainerTask(TaskSpec taskSpec, boolean shouldDie, Map<String, TezLocalResource> additionalResources, Credentials credentials, boolean credentialsChanged) {
        this.taskSpec = taskSpec;
        this.shouldDie = shouldDie;
        this.additionalResources = additionalResources;
        this.credentials = credentials;
        this.credentialsChanged = credentialsChanged;
    }

    public TaskSpec getTaskSpec() {
        return this.taskSpec;
    }

    public boolean shouldDie() {
        return this.shouldDie;
    }

    public Map<String, TezLocalResource> getAdditionalResources() {
        return this.additionalResources;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean haveCredentialsChanged() {
        return this.credentialsChanged;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.shouldDie);
        if (this.taskSpec != null) {
            out.writeBoolean(true);
            this.taskSpec.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.additionalResources != null) {
            out.writeInt(this.additionalResources.size());
            for (Map.Entry<String, TezLocalResource> lrEntry : this.additionalResources.entrySet()) {
                out.writeUTF(lrEntry.getKey());
                lrEntry.getValue().write(out);
            }
        } else {
            out.writeInt(-1);
        }
        out.writeBoolean(this.credentialsChanged);
        if (this.credentialsChanged) {
            out.writeBoolean(this.credentials != null);
            if (this.credentials != null) {
                this.credentials.write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        boolean hasCredentials;
        this.shouldDie = in.readBoolean();
        boolean taskComing = in.readBoolean();
        if (taskComing) {
            this.taskSpec = new TaskSpec();
            this.taskSpec.readFields(in);
        }
        int numAdditionalResources = in.readInt();
        this.additionalResources = Maps.newHashMap();
        if (numAdditionalResources != -1) {
            for (int i = 0; i < numAdditionalResources; ++i) {
                String resourceName = in.readUTF();
                TezLocalResource localResource = new TezLocalResource();
                localResource.readFields(in);
                this.additionalResources.put(resourceName, localResource);
            }
        }
        this.credentialsChanged = in.readBoolean();
        if (this.credentialsChanged && (hasCredentials = in.readBoolean())) {
            this.credentials = new Credentials();
            this.credentials.readFields(in);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("shouldDie: ").append(this.shouldDie);
        sb.append(", TaskSpec: ");
        if (this.taskSpec == null) {
            sb.append("none");
        } else {
            sb.append(this.taskSpec);
        }
        sb.append(", additionalResources: ");
        if (this.additionalResources == null) {
            sb.append("none");
        } else {
            sb.append(this.additionalResources);
        }
        sb.append(", credentialsChanged: ").append(this.credentialsChanged);
        sb.append(", credentials: ");
        if (this.credentials == null) {
            sb.append("none");
        } else {
            sb.append("#tokens=").append(this.credentials.numberOfTokens()).append(", #secretKeys: ").append(this.credentials.numberOfSecretKeys());
        }
        return sb.toString();
    }
}

