/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.writers;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUnorderedPartitionedKVWriter
extends KeyValuesWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseUnorderedPartitionedKVWriter.class);
    protected final OutputContext outputContext;
    protected final Configuration conf;
    protected final RawLocalFileSystem localFs;
    protected final Partitioner partitioner;
    protected final Class keyClass;
    protected final Class valClass;
    protected final Serializer keySerializer;
    protected final Serializer valSerializer;
    protected final SerializationFactory serializationFactory;
    protected final int numPartitions;
    protected final CompressionCodec codec;
    protected final TezTaskOutput outputFileHandler;
    protected final boolean ifileReadAhead;
    protected final int ifileReadAheadLength;
    protected final int ifileBufferSize;
    protected final TezCounter outputRecordBytesCounter;
    protected final TezCounter outputRecordsCounter;
    protected final TezCounter outputBytesWithOverheadCounter;
    protected final TezCounter fileOutputBytesCounter;
    protected final TezCounter spilledRecordsCounter;
    protected final TezCounter additionalSpillBytesWritternCounter;
    protected final TezCounter additionalSpillBytesReadCounter;
    protected final TezCounter numAdditionalSpillsCounter;
    protected final TezCounter dataViaEventSize;

    public BaseUnorderedPartitionedKVWriter(OutputContext outputContext, Configuration conf, int numOutputs) {
        this.outputContext = outputContext;
        this.conf = conf;
        try {
            this.localFs = (RawLocalFileSystem)FileSystem.getLocal((Configuration)conf).getRaw();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.numPartitions = numOutputs;
        this.keyClass = ConfigUtils.getIntermediateOutputKeyClass(this.conf);
        this.valClass = ConfigUtils.getIntermediateOutputValueClass(this.conf);
        this.serializationFactory = new SerializationFactory(this.conf);
        this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
        this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
        this.outputRecordBytesCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES);
        this.outputRecordsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_RECORDS);
        this.outputBytesWithOverheadCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_WITH_OVERHEAD);
        this.fileOutputBytesCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_PHYSICAL);
        this.spilledRecordsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.SPILLED_RECORDS);
        this.additionalSpillBytesWritternCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_WRITTEN);
        this.additionalSpillBytesReadCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILLS_BYTES_READ);
        this.numAdditionalSpillsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.ADDITIONAL_SPILL_COUNT);
        this.dataViaEventSize = outputContext.getCounters().findCounter((Enum)TaskCounter.DATA_BYTES_VIA_EVENT);
        if (ConfigUtils.shouldCompressIntermediateOutput(this.conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateOutputCompressorClass(this.conf, DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
        } else {
            this.codec = null;
        }
        this.ifileReadAhead = this.conf.getBoolean("tez.runtime.ifile.readahead", true);
        this.ifileReadAheadLength = this.ifileReadAhead ? conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000) : 0;
        this.ifileBufferSize = conf.getInt("io.file.buffer.size", -1);
        LOG.info("Instantiating Partitioner: [" + conf.get("tez.runtime.partitioner.class") + "]");
        try {
            this.partitioner = TezRuntimeUtils.instantiatePartitioner(this.conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.outputFileHandler = TezRuntimeUtils.instantiateTaskOutputManager(conf, outputContext);
    }

    @Override
    public abstract void write(Object var1, Object var2) throws IOException;

    @Override
    public void write(Object key, Iterable<Object> values) throws IOException {
        Iterator<Object> it = values.iterator();
        while (it.hasNext()) {
            this.write(key, it.next());
        }
    }

    public abstract List<Event> close() throws IOException, InterruptedException;
}

