/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.Preconditions;

@InterfaceAudience.Private
public class ConfigUtils {
    public static Class<? extends CompressionCodec> getIntermediateOutputCompressorClass(Configuration conf, Class<DefaultCodec> defaultValue) {
        Class<DefaultCodec> codecClass = defaultValue;
        String name = conf.get("tez.runtime.compress.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public static Class<? extends CompressionCodec> getIntermediateInputCompressorClass(Configuration conf, Class<DefaultCodec> defaultValue) {
        Class<DefaultCodec> codecClass = defaultValue;
        String name = conf.get("tez.runtime.compress.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public static boolean shouldCompressIntermediateOutput(Configuration conf) {
        return conf.getBoolean("tez.runtime.compress", false);
    }

    public static boolean isIntermediateInputCompressed(Configuration conf) {
        return conf.getBoolean("tez.runtime.compress", false);
    }

    public static <V> Class<V> getIntermediateOutputValueClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.value.class", null, Object.class);
        return retv;
    }

    public static <V> Class<V> getIntermediateInputValueClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.value.class", null, Object.class);
        return retv;
    }

    public static <K> Class<K> getIntermediateOutputKeyClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.key.class", null, Object.class);
        return retv;
    }

    public static <K> Class<K> getIntermediateInputKeyClass(Configuration conf) {
        Class retv = conf.getClass("tez.runtime.key.class", null, Object.class);
        return retv;
    }

    public static <K> RawComparator<K> getIntermediateOutputKeyComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
        }
        return WritableComparator.get(ConfigUtils.getIntermediateOutputKeyClass(conf).asSubclass(WritableComparable.class));
    }

    public static <K> RawComparator<K> getIntermediateInputKeyComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
        }
        return WritableComparator.get(ConfigUtils.getIntermediateInputKeyClass(conf).asSubclass(WritableComparable.class));
    }

    public static <V> RawComparator<V> getInputKeySecondaryGroupingComparator(Configuration conf) {
        Class theClass = conf.getClass("tez.runtime.key.secondary.comparator.class", null, RawComparator.class);
        if (theClass == null) {
            return ConfigUtils.getIntermediateInputKeyComparator(conf);
        }
        return (RawComparator)ReflectionUtils.newInstance((Class)theClass, (Configuration)conf);
    }

    public static boolean useNewApi(Configuration conf) {
        return conf.getBoolean("mapred.mapper.new-api", false);
    }

    @InterfaceAudience.Private
    public static Map<String, String> extractConfigurationMap(Map<String, String> confMap, Set<String> allowedKeys) {
        Preconditions.checkArgument((confMap != null ? 1 : 0) != 0, (Object)"ConfMap cannot be null");
        Preconditions.checkArgument((allowedKeys != null ? 1 : 0) != 0, (Object)"Valid key set cannot be empty");
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            if (!allowedKeys.contains(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @InterfaceAudience.Private
    public static void addConfigMapToConfiguration(Configuration conf, Map<String, String> confMap) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration cannot be null");
        Preconditions.checkArgument((confMap != null ? 1 : 0) != 0, (Object)"Configuration map cannot be null");
        for (Map.Entry<String, String> entry : confMap.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    @InterfaceAudience.Private
    public static Map<String, String> extractConfigurationMap(Map<String, String> confMap, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        Preconditions.checkArgument((confMap != null ? 1 : 0) != 0, (Object)"ConfMap cannot be null");
        Preconditions.checkArgument((validKeySets != null ? 1 : 0) != 0, (Object)"Valid key set cannot be empty");
        Preconditions.checkArgument((allowedPrefixes != null ? 1 : 0) != 0, (Object)"Allowed prefixes cannot be null");
        return ConfigUtils.extractConfigurationMapInternal(confMap.entrySet(), validKeySets, allowedPrefixes);
    }

    @InterfaceAudience.Private
    public static Map<String, String> extractConfigurationMap(Configuration conf, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"conf cannot be null");
        Preconditions.checkArgument((validKeySets != null ? 1 : 0) != 0, (Object)"Valid key set cannot be empty");
        Preconditions.checkArgument((allowedPrefixes != null ? 1 : 0) != 0, (Object)"Allowed prefixes cannot be null");
        return ConfigUtils.extractConfigurationMapInternal((Iterable<Map.Entry<String, String>>)conf, validKeySets, allowedPrefixes);
    }

    @InterfaceAudience.Private
    public static boolean doesKeyQualify(String key, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        Preconditions.checkArgument((validKeySets != null ? 1 : 0) != 0, (Object)"Valid key set cannot be empty");
        Preconditions.checkArgument((allowedPrefixes != null ? 1 : 0) != 0, (Object)"Allowed prefixes cannot be null");
        for (Set<String> set : validKeySets) {
            if (!set.contains(key)) continue;
            return true;
        }
        for (String prefix : allowedPrefixes) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    public static void mergeConfsWithExclusions(Configuration destConf, Map<String, String> srcConf, Set<String> excludedKeySet) {
        Preconditions.checkState((destConf != null ? 1 : 0) != 0, (Object)"Destination conf cannot be null");
        Preconditions.checkState((srcConf != null ? 1 : 0) != 0, (Object)"Source conf cannot be null");
        for (Map.Entry<String, String> entry : srcConf.entrySet()) {
            if (excludedKeySet.contains(entry.getKey())) continue;
            destConf.set(entry.getKey(), entry.getValue());
        }
    }

    public static void mergeConfs(Configuration destConf, Configuration srcConf) {
        Preconditions.checkState((destConf != null ? 1 : 0) != 0, (Object)"Destination conf cannot be null");
        Preconditions.checkState((srcConf != null ? 1 : 0) != 0, (Object)"Source conf cannot be null");
        for (Map.Entry entry : srcConf) {
            String val = srcConf.get((String)entry.getKey());
            destConf.set((String)entry.getKey(), val);
        }
    }

    private static Map<String, String> extractConfigurationMapInternal(Iterable<Map.Entry<String, String>> iterable, List<Set<String>> validKeySets, List<String> allowedPrefixes) {
        HashSet<String> validKeys = new HashSet<String>();
        for (Set<String> set : validKeySets) {
            validKeys.addAll(set);
        }
        HashMap<String, String> localConfMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : iterable) {
            if (validKeys.contains(entry.getKey())) {
                localConfMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (String prefix : allowedPrefixes) {
                if (!entry.getKey().startsWith(prefix)) continue;
                localConfMap.put(entry.getKey(), entry.getValue());
            }
        }
        return localConfMap;
    }
}

