/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class GZipUtils {
    public static final int BUFFER = 4096;
    public static final String EXT = ".gz";

    public static byte[] compress(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtils.compress(bais, baos);
        byte[] output = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return output;
    }

    public static void compress(File file) throws IOException {
        GZipUtils.compress(file, true);
    }

    public static void compress(File file, boolean delete) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        FileOutputStream fos = new FileOutputStream(file.getPath() + EXT);
        GZipUtils.compress(fis, fos);
        fis.close();
        fos.flush();
        fos.close();
        if (delete) {
            file.delete();
        }
    }

    public static void compress(InputStream is, OutputStream os) throws IOException {
        int count;
        GZIPOutputStream gos = new GZIPOutputStream(os, 4096);
        byte[] data = new byte[4096];
        while ((count = is.read(data, 0, 4096)) != -1) {
            gos.write(data, 0, count);
        }
        gos.finish();
        gos.flush();
        gos.close();
    }

    public static void compress(String path) throws IOException {
        GZipUtils.compress(path, true);
    }

    public static void compress(String path, boolean delete) throws IOException {
        File file = new File(path);
        GZipUtils.compress(file, delete);
    }

    public static byte[] decompress(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtils.decompress(bais, baos);
        data = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return data;
    }

    public static void decompress(File file) throws IOException {
        GZipUtils.decompress(file, true);
    }

    public static void decompress(File file, boolean delete) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        FileOutputStream fos = new FileOutputStream(file.getPath().replace(EXT, ""));
        GZipUtils.decompress(fis, fos);
        fis.close();
        fos.flush();
        fos.close();
        if (delete) {
            file.delete();
        }
    }

    public static void decompress(InputStream is, OutputStream os) throws IOException {
        int count;
        GZIPInputStream gis = new GZIPInputStream(is, 4096);
        byte[] data = new byte[4096];
        while ((count = gis.read(data, 0, 4096)) != -1) {
            os.write(data, 0, count);
        }
        gis.close();
    }

    public static void decompress(String path) throws IOException {
        GZipUtils.decompress(path, true);
    }

    public static void decompress(String path, boolean delete) throws IOException {
        File file = new File(path);
        GZipUtils.decompress(file, delete);
    }
}

