/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.activemq.listener;

import java.util.concurrent.ExecutorService;
import org.darkphoenixs.mq.consumer.MQConsumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.MQConsumerFactory;
import org.darkphoenixs.mq.listener.MQMessageListener;
import org.darkphoenixs.mq.util.RefleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFactoryConsumerListener<T>
implements MQMessageListener<T> {
    protected Logger logger = LoggerFactory.getLogger(MessageFactoryConsumerListener.class);
    private String consumerKeyField;
    private MQConsumerFactory consumerFactory;
    private ExecutorService threadPool;

    public String getConsumerKeyField() {
        return this.consumerKeyField;
    }

    public void setConsumerKeyField(String consumerKeyField) {
        this.consumerKeyField = consumerKeyField;
    }

    public MQConsumerFactory getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setConsumerFactory(MQConsumerFactory consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void onMessage(final T message) throws MQException {
        if (this.consumerFactory == null) {
            throw new MQException("MQConsumerFactory is null !");
        }
        if (this.consumerKeyField == null) {
            throw new MQException("ConsumerKeyField is null !");
        }
        if (message == null) {
            throw new MQException("Message is null !");
        }
        String consumerKey = (String)RefleTool.getMethodValue(message, "get" + this.consumerKeyField.substring(0, 1).toUpperCase() + this.consumerKeyField.substring(1));
        if (consumerKey == null) {
            throw new MQException("MQConsumer Key is null !");
        }
        final MQConsumer<T> consumer = this.consumerFactory.getConsumer(consumerKey);
        if (consumer == null) {
            throw new MQException("MQConsumer is null !");
        }
        if (this.threadPool == null) {
            consumer.receive(message);
        } else {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        consumer.receive(message);
                    }
                    catch (MQException e) {
                        MessageFactoryConsumerListener.this.logger.error("Receive message failed.", (Throwable)e);
                    }
                }
            });
        }
    }
}

