/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import kafka.admin.TopicCommand;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.security.JaasUtils;

public class KafkaCommand {
    private static final String space = " ";
    private static final int sessionTimeout = 30000;
    private static final int connectionTimeout = 30000;

    public static void listTopics(String zookeeperStr) {
        TopicCommand.listTopics((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(new String[]{"--list"}));
    }

    public static void createTopic(String zookeeperStr, String topic, int replications, int partitions) {
        TopicCommand.createTopic((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(new String[]{"--create", "--topic", topic, "--replication-factor", String.valueOf(replications), "--partitions", String.valueOf(partitions)}));
    }

    public static void describeTopic(String zookeeperStr, String topic) {
        TopicCommand.describeTopic((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--topic", topic}));
    }

    public static void alterTopic(String zookeeperStr, String topic, int partitions) {
        TopicCommand.alterTopic((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(new String[]{"--alter", "--topic", topic, "--partitions", String.valueOf(partitions)}));
    }

    public static void alterTopic(String zookeeperStr, String topic, String ... config) {
        StringBuffer updateOptions = new StringBuffer();
        updateOptions.append("--alter").append(space).append("--topic").append(space).append(topic);
        for (int i = 0; i < config.length; ++i) {
            if (config[i].indexOf("=") > 0) {
                updateOptions.append(space).append("--config").append(space).append(config[i]);
                continue;
            }
            updateOptions.append(space).append("--delete-config").append(space).append(config[i]);
        }
        TopicCommand.alterTopic((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(updateOptions.toString().split(space)));
    }

    public static void alterTopic(String zookeeperStr, String topic, int partitions, String ... config) {
        StringBuffer updateOptions = new StringBuffer();
        updateOptions.append("--alter").append(space).append("--topic").append(space).append(topic).append(space).append("--partitions").append(space).append(partitions);
        for (int i = 0; i < config.length; ++i) {
            if (config[i].indexOf("=") > 0) {
                updateOptions.append(space).append("--config").append(space).append(config[i]);
                continue;
            }
            updateOptions.append(space).append("--delete-config").append(space).append(config[i]);
        }
        TopicCommand.alterTopic((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(updateOptions.toString().split(space)));
    }

    public static void deleteTopic(String zookeeperStr, String topic) {
        TopicCommand.deleteTopic((ZkUtils)ZkUtils.apply((String)zookeeperStr, (int)30000, (int)30000, (boolean)JaasUtils.isZkSecurityEnabled()), (TopicCommand.TopicCommandOptions)new TopicCommand.TopicCommandOptions(new String[]{"--delete", "--topic", topic}));
    }
}

