/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.core;

import java.util.HashMap;
import java.util.Map;
import kafka.message.MessageAndMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.darkphoenixs.kafka.codec.KafkaMessageDecoder;
import org.darkphoenixs.kafka.core.KafkaDestination;
import org.darkphoenixs.kafka.listener.KafkaMessageListener;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.util.MQ_BATCH;
import org.darkphoenixs.mq.util.MQ_MODEL;

public class KafkaMessageAdapter<K, V> {
    private KafkaMessageDecoder<K, V> decoder;
    private KafkaMessageListener<K, V> messageListener;
    private KafkaDestination destination;
    private MQ_MODEL model;
    private MQ_BATCH batch;

    public KafkaMessageDecoder<K, V> getDecoder() {
        return this.decoder;
    }

    public void setDecoder(KafkaMessageDecoder<K, V> decoder) {
        this.decoder = decoder;
    }

    public KafkaMessageListener<K, V> getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(KafkaMessageListener<K, V> messageListener) {
        this.messageListener = messageListener;
    }

    @Deprecated
    public KafkaDestination getDestination() {
        return this.destination;
    }

    public String getModel() {
        if (this.model != null) {
            return this.model.name();
        }
        return null;
    }

    public void setModel(String model) {
        this.model = MQ_MODEL.valueOf(model);
    }

    public String getBatch() {
        if (this.batch != null) {
            return this.batch.name();
        }
        return null;
    }

    public void setBatch(String batch) {
        this.batch = MQ_BATCH.valueOf(batch);
    }

    @Deprecated
    public void setDestination(KafkaDestination destination) {
        this.destination = destination;
    }

    public void messageAdapter(MessageAndMetadata<?, ?> messageAndMetadata) throws MQException {
        byte[] keyBytes = (byte[])messageAndMetadata.key();
        byte[] valBytes = (byte[])messageAndMetadata.message();
        K k = this.decoder.decodeKey(keyBytes);
        V v = this.decoder.decodeVal(valBytes);
        this.messageListener.onMessage(k, v);
    }

    public void messageAdapter(ConsumerRecord<?, ?> consumerRecord) throws MQException {
        byte[] keyBytes = (byte[])consumerRecord.key();
        byte[] valBytes = (byte[])consumerRecord.value();
        K k = this.decoder.decodeKey(keyBytes);
        V v = this.decoder.decodeVal(valBytes);
        this.messageListener.onMessage(k, v);
    }

    public void messageAdapter(ConsumerRecords<?, ?> consumerRecords) throws MQException {
        HashMap<byte[], byte[]> map = new HashMap<byte[], byte[]>();
        for (ConsumerRecord consumerRecord : consumerRecords) {
            map.put((byte[])consumerRecord.key(), (byte[])consumerRecord.value());
        }
        Map<K, V> kv = this.decoder.batchDecode(map);
        this.messageListener.onMessage(kv);
    }

    @Deprecated
    protected void messageAdapterForMonitor(MessageAndMetadata<?, ?> messageAndMetadata) {
    }

    @Deprecated
    protected void messageAdapterForMonitor(ConsumerRecord<?, ?> consumerRecord) {
    }

    @Deprecated
    protected void messageAdapterForMonitor(ConsumerRecords<?, ?> consumerRecords) {
    }
}

