/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.kafka.producer;

import org.darkphoenixs.kafka.core.KafkaDestination;
import org.darkphoenixs.kafka.core.KafkaMessageTemplate;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.producer.MQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducer<K, V>
implements MQProducer<V> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private KafkaMessageTemplate<K, V> messageTemplate;
    private KafkaDestination destination;
    private String producerKey;

    public KafkaMessageTemplate<K, V> getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(KafkaMessageTemplate<K, V> messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public KafkaDestination getDestination() {
        return this.destination;
    }

    public void setDestination(KafkaDestination destination) {
        this.destination = destination;
    }

    @Override
    public void send(V message) throws MQException {
        try {
            V obj = this.doSend(message);
            this.messageTemplate.convertAndSend(this.destination, obj);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Send Success, ProducerKey : " + this.getProducerKey() + " , Message : " + message);
    }

    public void sendWithKey(K key, V message) throws MQException {
        try {
            V obj = this.doSend(message);
            this.messageTemplate.convertAndSendWithKey(this.destination, key, obj);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Send Success, ProducerKey : " + this.getProducerKey() + " , MessageKey : " + key + " , Message : " + message);
    }

    @Override
    public String getProducerKey() throws MQException {
        if (this.producerKey != null) {
            return this.producerKey;
        }
        return this.destination.getDestinationName();
    }

    public void setProducerKey(String producerKey) {
        this.producerKey = producerKey;
    }

    protected abstract V doSend(V var1) throws MQException;
}

