/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.mq.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.darkphoenixs.mq.consumer.MQConsumer;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.factory.MQConsumerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MQMessageConsumerFactory
implements MQConsumerFactory {
    private static final AtomicReference<MQMessageConsumerFactory> instance = new AtomicReference();
    protected Logger logger = LoggerFactory.getLogger(MQMessageConsumerFactory.class);
    private MQConsumer<?>[] consumers;
    private ConcurrentHashMap<String, MQConsumer<?>> consumerCache = new ConcurrentHashMap();

    private MQMessageConsumerFactory() {
    }

    public static synchronized MQConsumerFactory getInstance() {
        if (instance.get() == null) {
            instance.compareAndSet(null, new MQMessageConsumerFactory());
        }
        return instance.get();
    }

    public void setConsumers(MQConsumer<?>[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public <T> void addConsumer(MQConsumer<T> consumer) throws MQException {
        this.consumerCache.put(consumer.getConsumerKey(), consumer);
        this.logger.debug("Add MQConsumer : " + consumer.getConsumerKey());
    }

    @Override
    public <T> MQConsumer<T> getConsumer(String consumerKey) throws MQException {
        if (this.consumerCache.containsKey(consumerKey)) {
            this.logger.debug("Get MQConsumer : " + consumerKey);
            return this.consumerCache.get(consumerKey);
        }
        this.logger.warn("Unknown ConsumerKey : " + consumerKey);
        return null;
    }

    @Override
    public void init() throws MQException {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumerCache.put(this.consumers[i].getConsumerKey(), this.consumers[i]);
            }
        }
        this.logger.debug("Initialized!");
    }

    @Override
    public void destroy() throws MQException {
        if (this.consumers != null) {
            this.consumers = null;
        }
        if (instance.get() != null) {
            instance.set(null);
        }
        this.consumerCache.clear();
        this.logger.debug("Destroyed!");
    }
}

