/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.rocketmq.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.darkphoenixs.mq.consumer.MQConsumer;
import org.darkphoenixs.mq.exception.MQException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumer<T>
implements MQConsumer<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String consumerKey;

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    @Override
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @Override
    @Deprecated
    public void receive(T message) throws MQException {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, Message : " + message);
    }

    @Override
    @Deprecated
    public void receive(List<T> messages) throws MQException {
        try {
            this.doReceive(messages);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, Message size: " + messages.size());
    }

    public void receive(String key, T message) throws MQException {
        try {
            this.doReceive(key, message);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, Message : " + message);
    }

    @Override
    public void receive(Map<String, T> messages) throws MQException {
        try {
            this.doReceive(messages);
        }
        catch (Exception e) {
            throw new MQException(e);
        }
        this.logger.debug("Receive Success, Message size: " + messages.size());
    }

    protected void doReceive(T message) throws MQException {
    }

    protected void doReceive(List<T> messages) throws MQException {
    }

    protected void doReceive(String key, T message) throws MQException {
        this.doReceive(message);
    }

    protected void doReceive(Map<String, T> messages) throws MQException {
        this.doReceive((List<T>)new ArrayList<T>(messages.values()));
    }
}

