/*
 * Decompiled with CFR 0.152.
 */
package org.darkphoenixs.rocketmq.listener;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.darkphoenixs.mq.codec.MQMessageDecoder;
import org.darkphoenixs.mq.exception.MQException;
import org.darkphoenixs.mq.util.MQ_BATCH;
import org.darkphoenixs.mq.util.MQ_MODEL;
import org.darkphoenixs.rocketmq.consumer.AbstractConsumer;
import org.darkphoenixs.rocketmq.listener.RocketmqMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqMessageConsumerListener<T>
extends RocketmqMessageListener<T> {
    protected Logger logger = LoggerFactory.getLogger(RocketmqMessageConsumerListener.class);
    private MQMessageDecoder<T> messageDecoder;
    private AbstractConsumer<T> consumer;
    private MQ_BATCH batch = MQ_BATCH.NON_BATCH;
    private MQ_MODEL model = MQ_MODEL.MODEL_1;
    protected MessageListenerConcurrently messageListenerConcurrently = new MessageListenerConcurrently(){

        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> messages, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
            try {
                RocketmqMessageConsumerListener.this.consume(messages);
                RocketmqMessageConsumerListener.this.logger.debug("Consume Success: " + messages);
            }
            catch (Exception e) {
                RocketmqMessageConsumerListener.this.logger.error("Consume failed !", (Throwable)e);
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    };
    protected MessageListenerOrderly messageListenerOrderly = new MessageListenerOrderly(){

        public ConsumeOrderlyStatus consumeMessage(List<MessageExt> messages, ConsumeOrderlyContext consumeOrderlyContext) {
            try {
                RocketmqMessageConsumerListener.this.consume(messages);
                RocketmqMessageConsumerListener.this.logger.debug("Consume Success: " + messages);
            }
            catch (Exception e) {
                RocketmqMessageConsumerListener.this.logger.error("Consume failed !", (Throwable)e);
                return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
            }
            return ConsumeOrderlyStatus.SUCCESS;
        }
    };

    public MQMessageDecoder<T> getMessageDecoder() {
        return this.messageDecoder;
    }

    public void setMessageDecoder(MQMessageDecoder<T> messageDecoder) {
        this.messageDecoder = messageDecoder;
    }

    public AbstractConsumer<T> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(AbstractConsumer<T> consumer) {
        this.consumer = consumer;
    }

    public String getBatch() {
        return this.batch.name();
    }

    public void setBatch(String batch) {
        this.batch = MQ_BATCH.valueOf(batch);
    }

    public String getModel() {
        return this.model.name();
    }

    public void setModel(String model) {
        this.model = MQ_MODEL.valueOf(model);
    }

    @Override
    @Deprecated
    public void onMessage(T message) throws MQException {
        if (this.consumer == null) {
            throw new MQException("Consumer is null !");
        }
        this.consumer.receive(message);
        this.logger.debug("Consume Success, Message : " + message);
    }

    @Override
    @Deprecated
    public void onMessage(List<T> messages) throws MQException {
        if (this.consumer == null) {
            throw new MQException("Consumer is null !");
        }
        this.consumer.receive(messages);
        this.logger.debug("Consume Success, Message size: " + messages.size());
    }

    @Override
    public void onMessage(String key, T message) throws MQException {
        if (this.consumer == null) {
            throw new MQException("Consumer is null !");
        }
        this.consumer.receive(key, message);
        this.logger.debug("Consume Success, Message : " + message);
    }

    @Override
    public void onMessage(Map<String, T> messages) throws MQException {
        if (this.consumer == null) {
            throw new MQException("Consumer is null !");
        }
        this.consumer.receive(messages);
        this.logger.debug("Consume Success, Message size: " + messages.size());
    }

    @Override
    public MessageListener getMessageListener() {
        MessageListenerOrderly messageListener = null;
        switch (this.model) {
            case MODEL_1: {
                messageListener = this.messageListenerOrderly;
                break;
            }
            case MODEL_2: {
                messageListener = this.messageListenerConcurrently;
            }
        }
        return messageListener;
    }

    private void consume(List<MessageExt> messages) throws MQException {
        switch (this.batch) {
            case BATCH: {
                IdentityHashMap<String, T> identityHashMap = new IdentityHashMap<String, T>();
                for (MessageExt message : messages) {
                    identityHashMap.put(message.getKeys(), this.messageDecoder.decode(message.getBody()));
                }
                this.onMessage((Map<String, T>)identityHashMap);
                break;
            }
            case NON_BATCH: {
                for (MessageExt message : messages) {
                    this.onMessage(message.getKeys(), this.messageDecoder.decode(message.getBody()));
                }
                break;
            }
        }
    }
}

