/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.style.NamedStyles;

@Mojo(name="discover", threadSafe=true, requiresProject=false, aggregator=true)
public class RewriteDiscoverMojo
extends AbstractRewriteMojo {
    @Parameter(property="recipe")
    @Nullable String recipe;
    @Parameter(property="detail", defaultValue="false")
    boolean detail;
    @Parameter(property="recursion", defaultValue="0")
    int recursion;
    private static final String RECIPE_NOT_FOUND_EXCEPTION_MSG = "Could not find recipe '%s' among available recipes";

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        Collection availableRecipeDescriptors = env.listRecipeDescriptors();
        if (this.recipe != null) {
            RecipeDescriptor rd = RewriteDiscoverMojo.getRecipeDescriptor(this.recipe, availableRecipeDescriptors);
            this.writeRecipeDescriptor(rd, this.detail, 0, 0);
        } else {
            HashSet<RecipeDescriptor> activeRecipeDescriptors = new HashSet<RecipeDescriptor>();
            for (String activeRecipe : this.getActiveRecipes()) {
                RecipeDescriptor rd = RewriteDiscoverMojo.getRecipeDescriptor(activeRecipe, availableRecipeDescriptors);
                activeRecipeDescriptors.add(rd);
            }
            this.writeDiscovery(availableRecipeDescriptors, activeRecipeDescriptors, env.listStyles());
        }
    }

    private static RecipeDescriptor getRecipeDescriptor(String recipe, Collection<RecipeDescriptor> recipeDescriptors) throws MojoExecutionException {
        return recipeDescriptors.stream().filter(r -> r.getName().equalsIgnoreCase(recipe)).findAny().orElseThrow(() -> new MojoExecutionException(String.format(RECIPE_NOT_FOUND_EXCEPTION_MSG, recipe)));
    }

    private void writeDiscovery(Collection<RecipeDescriptor> availableRecipeDescriptors, Collection<RecipeDescriptor> activeRecipeDescriptors, Collection<NamedStyles> availableStyles) {
        ArrayList<RecipeDescriptor> availableRecipesSorted = new ArrayList<RecipeDescriptor>(availableRecipeDescriptors);
        availableRecipesSorted.sort(Comparator.comparing(RecipeDescriptor::getName, String.CASE_INSENSITIVE_ORDER));
        this.getLog().info((CharSequence)"Available Recipes:");
        for (RecipeDescriptor recipeDescriptor : availableRecipesSorted) {
            this.writeRecipeDescriptor(recipeDescriptor, this.detail, 0, 1);
        }
        ArrayList<NamedStyles> availableStylesSorted = new ArrayList<NamedStyles>(availableStyles);
        availableStylesSorted.sort(Comparator.comparing(NamedStyles::getName, String.CASE_INSENSITIVE_ORDER));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Available Styles:");
        for (NamedStyles namedStyles : availableStylesSorted) {
            this.getLog().info((CharSequence)("    " + namedStyles.getName()));
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.getActiveStyles());
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Active Styles:");
        for (String activeStyle : arrayList) {
            this.getLog().info((CharSequence)("    " + activeStyle));
        }
        ArrayList<RecipeDescriptor> arrayList2 = new ArrayList<RecipeDescriptor>(activeRecipeDescriptors);
        arrayList2.sort(Comparator.comparing(RecipeDescriptor::getName, String.CASE_INSENSITIVE_ORDER));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Active Recipes:");
        for (RecipeDescriptor recipeDescriptor : arrayList2) {
            this.writeRecipeDescriptor(recipeDescriptor, this.detail, 0, 1);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Found " + availableRecipeDescriptors.size() + " available recipes and " + availableStyles.size() + " available styles."));
        this.getLog().info((CharSequence)("Configured with " + activeRecipeDescriptors.size() + " active recipes and " + this.getActiveStyles().size() + " active styles."));
    }

    private void writeRecipeDescriptor(RecipeDescriptor rd, boolean verbose, int currentRecursionLevel, int indentLevel) {
        String indent = StringUtils.repeat((String)"    ", (int)indentLevel);
        if (currentRecursionLevel <= this.recursion) {
            if (verbose) {
                this.getLog().info((CharSequence)(indent + rd.getDisplayName()));
                this.getLog().info((CharSequence)(indent + "    " + rd.getName()));
                if (rd.getDescription() != null && !rd.getDescription().isEmpty()) {
                    this.getLog().info((CharSequence)(indent + "    " + rd.getDescription()));
                }
                if (!rd.getOptions().isEmpty()) {
                    this.getLog().info((CharSequence)(indent + "options: "));
                    for (OptionDescriptor od : rd.getOptions()) {
                        this.getLog().info((CharSequence)(indent + "    " + od.getName() + ": " + od.getType() + (od.isRequired() ? "!" : "")));
                        if (od.getDescription() == null || od.getDescription().isEmpty()) continue;
                        this.getLog().info((CharSequence)(indent + "        " + od.getDescription()));
                    }
                }
            } else {
                this.getLog().info((CharSequence)(indent + rd.getName()));
            }
            if (!rd.getRecipeList().isEmpty() && currentRecursionLevel + 1 <= this.recursion) {
                this.getLog().info((CharSequence)(indent + "recipeList:"));
                for (RecipeDescriptor r : rd.getRecipeList()) {
                    this.writeRecipeDescriptor(r, verbose, currentRecursionLevel + 1, indentLevel + 1);
                }
            }
            if (verbose) {
                this.getLog().info((CharSequence)"");
            }
        }
    }
}

