package org.openqa.selenium.devtools.v115.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class OriginTrialToken {

    private final java.lang.String origin;

    private final java.lang.Boolean matchSubDomains;

    private final java.lang.String trialName;

    private final org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch expiryTime;

    private final java.lang.Boolean isThirdParty;

    private final org.openqa.selenium.devtools.v115.page.model.OriginTrialUsageRestriction usageRestriction;

    public OriginTrialToken(java.lang.String origin, java.lang.Boolean matchSubDomains, java.lang.String trialName, org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch expiryTime, java.lang.Boolean isThirdParty, org.openqa.selenium.devtools.v115.page.model.OriginTrialUsageRestriction usageRestriction) {
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.matchSubDomains = java.util.Objects.requireNonNull(matchSubDomains, "matchSubDomains is required");
        this.trialName = java.util.Objects.requireNonNull(trialName, "trialName is required");
        this.expiryTime = java.util.Objects.requireNonNull(expiryTime, "expiryTime is required");
        this.isThirdParty = java.util.Objects.requireNonNull(isThirdParty, "isThirdParty is required");
        this.usageRestriction = java.util.Objects.requireNonNull(usageRestriction, "usageRestriction is required");
    }

    public java.lang.String getOrigin() {
        return origin;
    }

    public java.lang.Boolean getMatchSubDomains() {
        return matchSubDomains;
    }

    public java.lang.String getTrialName() {
        return trialName;
    }

    public org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch getExpiryTime() {
        return expiryTime;
    }

    public java.lang.Boolean getIsThirdParty() {
        return isThirdParty;
    }

    public org.openqa.selenium.devtools.v115.page.model.OriginTrialUsageRestriction getUsageRestriction() {
        return usageRestriction;
    }

    private static OriginTrialToken fromJson(JsonInput input) {
        java.lang.String origin = null;
        java.lang.Boolean matchSubDomains = false;
        java.lang.String trialName = null;
        org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch expiryTime = null;
        java.lang.Boolean isThirdParty = false;
        org.openqa.selenium.devtools.v115.page.model.OriginTrialUsageRestriction usageRestriction = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "origin":
                    origin = input.nextString();
                    break;
                case "matchSubDomains":
                    matchSubDomains = input.nextBoolean();
                    break;
                case "trialName":
                    trialName = input.nextString();
                    break;
                case "expiryTime":
                    expiryTime = input.read(org.openqa.selenium.devtools.v115.network.model.TimeSinceEpoch.class);
                    break;
                case "isThirdParty":
                    isThirdParty = input.nextBoolean();
                    break;
                case "usageRestriction":
                    usageRestriction = input.read(org.openqa.selenium.devtools.v115.page.model.OriginTrialUsageRestriction.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new OriginTrialToken(origin, matchSubDomains, trialName, expiryTime, isThirdParty, usageRestriction);
    }
}
