package org.openqa.selenium.devtools.v116.accessibility.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class AXRelatedNode {

    private final org.openqa.selenium.devtools.v116.dom.model.BackendNodeId backendDOMNodeId;

    private final java.util.Optional<java.lang.String> idref;

    private final java.util.Optional<java.lang.String> text;

    public AXRelatedNode(org.openqa.selenium.devtools.v116.dom.model.BackendNodeId backendDOMNodeId, java.util.Optional<java.lang.String> idref, java.util.Optional<java.lang.String> text) {
        this.backendDOMNodeId = java.util.Objects.requireNonNull(backendDOMNodeId, "backendDOMNodeId is required");
        this.idref = idref;
        this.text = text;
    }

    /**
     * The BackendNodeId of the related DOM node.
     */
    public org.openqa.selenium.devtools.v116.dom.model.BackendNodeId getBackendDOMNodeId() {
        return backendDOMNodeId;
    }

    /**
     * The IDRef value provided, if any.
     */
    public java.util.Optional<java.lang.String> getIdref() {
        return idref;
    }

    /**
     * The text alternative of this node in the current context.
     */
    public java.util.Optional<java.lang.String> getText() {
        return text;
    }

    private static AXRelatedNode fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v116.dom.model.BackendNodeId backendDOMNodeId = null;
        java.util.Optional<java.lang.String> idref = java.util.Optional.empty();
        java.util.Optional<java.lang.String> text = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "backendDOMNodeId":
                    backendDOMNodeId = input.read(org.openqa.selenium.devtools.v116.dom.model.BackendNodeId.class);
                    break;
                case "idref":
                    idref = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "text":
                    text = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AXRelatedNode(backendDOMNodeId, idref, text);
    }
}
