package org.openqa.selenium.devtools.v116.webauthn.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Triggered when a credential is used in a webauthn assertion.
 */
public class CredentialAsserted {

    private final org.openqa.selenium.devtools.v116.webauthn.model.AuthenticatorId authenticatorId;

    private final org.openqa.selenium.devtools.v116.webauthn.model.Credential credential;

    public CredentialAsserted(org.openqa.selenium.devtools.v116.webauthn.model.AuthenticatorId authenticatorId, org.openqa.selenium.devtools.v116.webauthn.model.Credential credential) {
        this.authenticatorId = java.util.Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        this.credential = java.util.Objects.requireNonNull(credential, "credential is required");
    }

    public org.openqa.selenium.devtools.v116.webauthn.model.AuthenticatorId getAuthenticatorId() {
        return authenticatorId;
    }

    public org.openqa.selenium.devtools.v116.webauthn.model.Credential getCredential() {
        return credential;
    }

    private static CredentialAsserted fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v116.webauthn.model.AuthenticatorId authenticatorId = null;
        org.openqa.selenium.devtools.v116.webauthn.model.Credential credential = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "authenticatorId":
                    authenticatorId = input.read(org.openqa.selenium.devtools.v116.webauthn.model.AuthenticatorId.class);
                    break;
                case "credential":
                    credential = input.read(org.openqa.selenium.devtools.v116.webauthn.model.Credential.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CredentialAsserted(authenticatorId, credential);
    }
}
