/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.undertow.autoconfigure.reactive;

import io.undertow.Undertow;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.undertow.autoconfigure.UndertowServerProperties;
import org.springframework.boot.undertow.autoconfigure.UndertowWebServerConfiguration;
import org.springframework.boot.undertow.reactive.UndertowReactiveWebServerFactory;
import org.springframework.boot.web.server.autoconfigure.reactive.ReactiveWebServerConfiguration;
import org.springframework.boot.web.server.reactive.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.ReactiveHttpInputMessage;

@AutoConfiguration
@ConditionalOnClass(value={ReactiveHttpInputMessage.class, Undertow.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={UndertowServerProperties.class})
@Import(value={UndertowWebServerConfiguration.class, ReactiveWebServerConfiguration.class})
public class UndertowReactiveWebServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    UndertowReactiveWebServerFactory undertowReactiveWebServerFactory(ObjectProvider<UndertowBuilderCustomizer> builderCustomizers) {
        UndertowReactiveWebServerFactory factory = new UndertowReactiveWebServerFactory();
        factory.getBuilderCustomizers().addAll(builderCustomizers.orderedStream().toList());
        return factory;
    }
}

