/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.intercept;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;

public final class AuthorizationChannelInterceptor
implements ChannelInterceptor {
    private Supplier<Authentication> authentication = this.getAuthentication(SecurityContextHolder.getContextHolderStrategy());
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AuthorizationManager<Message<?>> preSendAuthorizationManager;
    private AuthorizationEventPublisher eventPublisher = new NoopAuthorizationEventPublisher();

    public AuthorizationChannelInterceptor(AuthorizationManager<Message<?>> preSendAuthorizationManager) {
        Assert.notNull(preSendAuthorizationManager, (String)"preSendAuthorizationManager cannot be null");
        this.preSendAuthorizationManager = preSendAuthorizationManager;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        this.logger.debug((Object)LogMessage.of(() -> "Authorizing message send"));
        AuthorizationResult result = this.preSendAuthorizationManager.authorize(this.authentication, message);
        this.eventPublisher.publishAuthorizationEvent(this.authentication, message, result);
        if (result == null || !result.isGranted()) {
            this.logger.debug((Object)LogMessage.of(() -> "Failed to authorize message with authorization manager " + String.valueOf(this.preSendAuthorizationManager) + " and result " + String.valueOf(result)));
            throw new AccessDeniedException("Access Denied");
        }
        this.logger.debug((Object)LogMessage.of(() -> "Authorized message send"));
        return message;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.authentication = this.getAuthentication(securityContextHolderStrategy);
    }

    public void setAuthorizationEventPublisher(AuthorizationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    private Supplier<Authentication> getAuthentication(SecurityContextHolderStrategy strategy) {
        return () -> {
            Authentication authentication = strategy.getContext().getAuthentication();
            if (authentication == null) {
                throw new AuthenticationCredentialsNotFoundException("An Authentication object was not found in the SecurityContext");
            }
            return authentication;
        };
    }

    private static class NoopAuthorizationEventPublisher
    implements AuthorizationEventPublisher {
        private NoopAuthorizationEventPublisher() {
        }

        public <T> void publishAuthorizationEvent(Supplier<Authentication> authentication, T object, AuthorizationResult result) {
        }
    }
}

