/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.logout;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class LogoutFilter
extends GenericFilterBean {
    private String filterProcessesUrl;
    private RequestMatcher logoutRequestMatcher;
    private final List<LogoutHandler> handlers;
    private final LogoutSuccessHandler logoutSuccessHandler;

    public LogoutFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler ... handlers) {
        Assert.notEmpty((Object[])handlers, (String)"LogoutHandlers are required");
        this.handlers = Arrays.asList(handlers);
        Assert.notNull((Object)logoutSuccessHandler, (String)"logoutSuccessHandler cannot be null");
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.setFilterProcessesUrl("/j_spring_security_logout");
    }

    public LogoutFilter(String logoutSuccessUrl, LogoutHandler ... handlers) {
        Assert.notEmpty((Object[])handlers, (String)"LogoutHandlers are required");
        this.handlers = Arrays.asList(handlers);
        Assert.isTrue((!StringUtils.hasLength((String)logoutSuccessUrl) || UrlUtils.isValidRedirectUrl(logoutSuccessUrl) ? 1 : 0) != 0, (String)(logoutSuccessUrl + " isn't a valid redirect URL"));
        SimpleUrlLogoutSuccessHandler urlLogoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        if (StringUtils.hasText((String)logoutSuccessUrl)) {
            urlLogoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl);
        }
        this.logoutSuccessHandler = urlLogoutSuccessHandler;
        this.setFilterProcessesUrl("/j_spring_security_logout");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.requiresLogout(request, response)) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Logging out user '" + auth + "' and transferring to logout destination"));
            }
            for (LogoutHandler handler : this.handlers) {
                handler.logout(request, response, auth);
            }
            this.logoutSuccessHandler.onLogoutSuccess(request, response, auth);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected boolean requiresLogout(HttpServletRequest request, HttpServletResponse response) {
        return this.logoutRequestMatcher.matches(request);
    }

    public void setLogoutRequestMatcher(RequestMatcher logoutRequestMatcher) {
        Assert.notNull((Object)logoutRequestMatcher, (String)"logoutRequestMatcher cannot be null");
        this.logoutRequestMatcher = logoutRequestMatcher;
        this.filterProcessesUrl = null;
    }

    @Deprecated
    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.logoutRequestMatcher = new FilterProcessUrlRequestMatcher(filterProcessesUrl);
        this.filterProcessesUrl = filterProcessesUrl;
    }

    @Deprecated
    protected String getFilterProcessesUrl() {
        return this.filterProcessesUrl;
    }

    private static final class FilterProcessUrlRequestMatcher
    implements RequestMatcher {
        private final String filterProcessesUrl;

        private FilterProcessUrlRequestMatcher(String filterProcessesUrl) {
            Assert.hasLength((String)filterProcessesUrl, (String)"filterProcessesUrl must be specified");
            Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl(filterProcessesUrl), (String)(filterProcessesUrl + " isn't a valid redirect URL"));
            this.filterProcessesUrl = filterProcessesUrl;
        }

        public boolean matches(HttpServletRequest request) {
            int queryParamIndex;
            String uri = request.getRequestURI();
            int pathParamIndex = uri.indexOf(59);
            if (pathParamIndex > 0) {
                uri = uri.substring(0, pathParamIndex);
            }
            if ((queryParamIndex = uri.indexOf(63)) > 0) {
                uri = uri.substring(0, queryParamIndex);
            }
            if ("".equals(request.getContextPath())) {
                return uri.endsWith(this.filterProcessesUrl);
            }
            return uri.endsWith(request.getContextPath() + this.filterProcessesUrl);
        }
    }
}

