/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.client.BlockOutStream;
import tachyon.client.OutStream;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.util.CommonUtils;

public class FileOutStream
extends OutStream {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final long BLOCK_CAPACITY;
    private BlockOutStream mCurrentBlockOutStream;
    private long mCurrentBlockId;
    private long mCurrentBlockLeftByte;
    private List<BlockOutStream> mPreviousBlockOutStreams;
    private long mCachedBytes;
    private OutputStream mCheckpointOutputStream = null;
    private String mUnderFsFile = null;
    private boolean mClosed = false;
    private boolean mCancel = false;

    FileOutStream(TachyonFile file, WriteType opType, Object ufsConf) throws IOException {
        super(file, opType);
        this.BLOCK_CAPACITY = file.getBlockSizeByte();
        this.mCurrentBlockOutStream = null;
        this.mCurrentBlockId = -1L;
        this.mCurrentBlockLeftByte = 0L;
        this.mPreviousBlockOutStreams = new ArrayList<BlockOutStream>();
        this.mCachedBytes = 0L;
        if (this.WRITE_TYPE.isThrough()) {
            this.mUnderFsFile = CommonUtils.concat(this.TFS.createAndGetUserUnderfsTempFolder(), this.FILE.FID);
            UnderFileSystem underfsClient = UnderFileSystem.get(this.mUnderFsFile, ufsConf);
            if (this.BLOCK_CAPACITY > Integer.MAX_VALUE) {
                throw new IOException("BLOCK_CAPCAITY (" + this.BLOCK_CAPACITY + ") can not bigger than " + Integer.MAX_VALUE);
            }
            this.mCheckpointOutputStream = underfsClient.create(this.mUnderFsFile, (int)this.BLOCK_CAPACITY);
        }
    }

    @Override
    public void cancel() throws IOException {
        this.mCancel = true;
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            if (this.mCurrentBlockOutStream != null) {
                this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
            }
            Boolean canComplete = false;
            if (this.WRITE_TYPE.isThrough()) {
                if (this.mCancel) {
                    this.mCheckpointOutputStream.close();
                    UnderFileSystem underFsClient = UnderFileSystem.get(this.mUnderFsFile);
                    underFsClient.delete(this.mUnderFsFile, false);
                } else {
                    this.mCheckpointOutputStream.flush();
                    this.mCheckpointOutputStream.close();
                    this.TFS.addCheckpoint(this.FILE.FID);
                    canComplete = true;
                }
            }
            if (this.WRITE_TYPE.isCache()) {
                try {
                    if (this.mCancel) {
                        for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                            bos.cancel();
                        }
                    } else {
                        for (BlockOutStream bos : this.mPreviousBlockOutStreams) {
                            bos.close();
                        }
                        canComplete = true;
                    }
                }
                catch (IOException ioe) {
                    if (this.WRITE_TYPE.isMustCache()) {
                        this.LOG.error((Object)ioe.getMessage());
                        throw new IOException("Fail to cache: " + (Object)((Object)this.WRITE_TYPE));
                    }
                    this.LOG.warn((Object)("Fail to cache for: " + ioe.getMessage()));
                }
            }
            if (canComplete.booleanValue()) {
                if (this.WRITE_TYPE.isAsync()) {
                    this.TFS.asyncCheckpoint(this.FILE.FID);
                }
                this.TFS.completeFile(this.FILE.FID);
            }
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.WRITE_TYPE.isThrough()) {
            this.mCheckpointOutputStream.flush();
        }
    }

    private void getNextBlock() throws IOException {
        if (this.mCurrentBlockId != -1L) {
            if (this.mCurrentBlockLeftByte != 0L) {
                throw new IOException("The current block still has space left, no need to get new block");
            }
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        if (this.WRITE_TYPE.isCache()) {
            this.mCurrentBlockId = this.TFS.getBlockIdBasedOnOffset(this.FILE.FID, this.mCachedBytes);
            this.mCurrentBlockLeftByte = this.BLOCK_CAPACITY;
            this.mCurrentBlockOutStream = new BlockOutStream(this.FILE, this.WRITE_TYPE, (int)(this.mCachedBytes / this.BLOCK_CAPACITY));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.WRITE_TYPE.isCache()) {
            try {
                int tLen = len;
                int tOff = off;
                while (tLen > 0) {
                    if (this.mCurrentBlockLeftByte == 0L) {
                        this.getNextBlock();
                    } else if (this.mCurrentBlockLeftByte < 0L || this.mCurrentBlockOutStream == null) {
                        throw new IOException("mCurrentBlockLeftByte " + this.mCurrentBlockLeftByte + " " + this.mCurrentBlockOutStream);
                    }
                    if (this.mCurrentBlockLeftByte >= (long)tLen) {
                        this.mCurrentBlockOutStream.write(b, tOff, tLen);
                        this.mCurrentBlockLeftByte -= (long)tLen;
                        this.mCachedBytes += (long)tLen;
                        tOff += tLen;
                        tLen = 0;
                        continue;
                    }
                    this.mCurrentBlockOutStream.write(b, tOff, (int)this.mCurrentBlockLeftByte);
                    tOff = (int)((long)tOff + this.mCurrentBlockLeftByte);
                    tLen = (int)((long)tLen - this.mCurrentBlockLeftByte);
                    this.mCachedBytes += this.mCurrentBlockLeftByte;
                    this.mCurrentBlockLeftByte = 0L;
                }
            }
            catch (IOException ioe) {
                if (this.WRITE_TYPE.isMustCache()) {
                    this.LOG.error((Object)ioe.getMessage());
                    throw new IOException("Fail to cache: " + (Object)((Object)this.WRITE_TYPE));
                }
                this.LOG.warn((Object)("Fail to cache for: " + ioe.getMessage()));
            }
        }
        if (this.WRITE_TYPE.isThrough()) {
            this.mCheckpointOutputStream.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.WRITE_TYPE.isCache()) {
            try {
                if (this.mCurrentBlockId == -1L || this.mCurrentBlockLeftByte == 0L) {
                    this.getNextBlock();
                }
                this.mCurrentBlockOutStream.write(b);
                --this.mCurrentBlockLeftByte;
                ++this.mCachedBytes;
            }
            catch (IOException ioe) {
                if (this.WRITE_TYPE.isMustCache()) {
                    this.LOG.error((Object)ioe.getMessage());
                    throw new IOException("Fail to cache: " + (Object)((Object)this.WRITE_TYPE));
                }
                this.LOG.warn((Object)("Fail to cache for: " + ioe.getMessage()));
            }
        }
        if (this.WRITE_TYPE.isThrough()) {
            this.mCheckpointOutputStream.write(b);
        }
    }
}

