/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.client.BlockInStream;
import tachyon.client.BlockOutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.UserConf;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.CommonUtils;
import tachyon.worker.DataServerMessage;

public class RemoteBlockInStream
extends BlockInStream {
    private static final int BUFFER_SIZE = UserConf.get().REMOTE_READ_BUFFER_SIZE_BYTE;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private ClientBlockInfo mBlockInfo;
    private InputStream mCheckpointInputStream = null;
    private long mReadByte;
    private ByteBuffer mCurrentBuffer = null;
    private long mBufferStartPosition = 0L;
    private boolean mRecache = true;
    private BlockOutStream mBlockOutStream = null;
    private Object mUFSConf = null;

    RemoteBlockInStream(TachyonFile file, ReadType readType, int blockIndex) throws IOException {
        this(file, readType, blockIndex, null);
    }

    RemoteBlockInStream(TachyonFile file, ReadType readType, int blockIndex, Object ufsConf) throws IOException {
        super(file, readType, blockIndex);
        this.mBlockInfo = this.TFS.getClientBlockInfo(this.FILE.FID, this.BLOCK_INDEX);
        this.mReadByte = 0L;
        this.mBufferStartPosition = 0L;
        if (!this.FILE.isComplete()) {
            throw new IOException("File " + this.FILE.getPath() + " is not ready to read");
        }
        this.mRecache = readType.isCache();
        if (this.mRecache) {
            this.mBlockOutStream = new BlockOutStream(file, WriteType.TRY_CACHE, blockIndex);
        }
        this.updateCurrentBuffer();
        this.mUFSConf = ufsConf;
        if (this.mCurrentBuffer == null) {
            this.setupStreamFromUnderFs(this.mBlockInfo.offset, this.mUFSConf);
            if (this.mCheckpointInputStream == null) {
                this.TFS.reportLostFile(this.FILE.FID);
                throw new IOException("Can not find the block " + this.FILE + " " + this.BLOCK_INDEX);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            if (this.mRecache) {
                this.mBlockOutStream.cancel();
            }
            if (this.mCheckpointInputStream != null) {
                this.mCheckpointInputStream.close();
            }
        }
        this.mClosed = true;
    }

    private void doneRecache() throws IOException {
        if (this.mRecache) {
            this.mBlockOutStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        ++this.mReadByte;
        if (this.mReadByte > this.mBlockInfo.length) {
            this.doneRecache();
            return -1;
        }
        if (this.mCurrentBuffer != null) {
            if (this.mCurrentBuffer.remaining() == 0) {
                this.mBufferStartPosition = this.mReadByte - 1L;
                this.updateCurrentBuffer();
            }
            if (this.mCurrentBuffer != null) {
                int ret = this.mCurrentBuffer.get() & 0xFF;
                if (this.mRecache) {
                    this.mBlockOutStream.write(ret);
                }
                return ret;
            }
            this.setupStreamFromUnderFs(this.mBlockInfo.offset + this.mReadByte - 1L, this.mUFSConf);
        }
        int ret = this.mCheckpointInputStream.read() & 0xFF;
        if (this.mRecache) {
            this.mBlockOutStream.write(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long ret = this.mBlockInfo.length - this.mReadByte;
        if (ret < (long)len) {
            len = (int)ret;
        }
        if (ret == 0L) {
            return -1;
        }
        if (this.mCurrentBuffer != null) {
            if (this.mCurrentBuffer.remaining() == 0) {
                this.mBufferStartPosition = this.mReadByte;
                this.updateCurrentBuffer();
            }
            if (this.mCurrentBuffer != null) {
                ret = Math.min(ret, (long)this.mCurrentBuffer.remaining());
                ret = Math.min(ret, (long)len);
                this.mCurrentBuffer.get(b, off, (int)ret);
                this.mReadByte += ret;
                if (this.mRecache) {
                    this.mBlockOutStream.write(b, off, (int)ret);
                    if (this.mReadByte == this.mBlockInfo.length) {
                        this.doneRecache();
                    }
                }
                return (int)ret;
            }
            this.setupStreamFromUnderFs(this.mBlockInfo.offset + this.mReadByte, this.mUFSConf);
        }
        ret = this.mCheckpointInputStream.read(b, off, len);
        this.mReadByte += ret;
        if (this.mRecache) {
            this.mBlockOutStream.write(b, off, (int)ret);
            if (this.mReadByte == this.mBlockInfo.length) {
                this.doneRecache();
            }
        }
        return (int)ret;
    }

    private ByteBuffer readRemoteByteBuffer(ClientBlockInfo blockInfo, long offset, long len) {
        ByteBuffer buf = null;
        try {
            List<NetAddress> blockLocations = blockInfo.getLocations();
            this.LOG.info((Object)("Block locations:" + blockLocations));
            for (int k = 0; k < blockLocations.size(); ++k) {
                String host = blockLocations.get((int)k).mHost;
                int port = blockLocations.get((int)k).mPort;
                if (port == -1) continue;
                if (host.equals(InetAddress.getLocalHost().getHostName()) || host.equals(InetAddress.getLocalHost().getHostAddress())) {
                    String localFileName = CommonUtils.concat(this.TFS.getRootFolder(), blockInfo.blockId);
                    this.LOG.warn((Object)("Master thinks the local machine has data " + localFileName + "! But not!"));
                }
                this.LOG.info((Object)(host + ":" + (port + 1) + " current host is " + InetAddress.getLocalHost().getHostName() + " " + InetAddress.getLocalHost().getHostAddress()));
                try {
                    buf = this.retrieveByteBufferFromRemoteMachine(new InetSocketAddress(host, port + 1), blockInfo.blockId, offset, len);
                    if (buf == null) continue;
                    break;
                }
                catch (IOException e) {
                    this.LOG.error((Object)e.getMessage());
                    buf = null;
                }
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)("Failed to get read data from remote " + e.getMessage()));
            buf = null;
        }
        return buf;
    }

    private ByteBuffer retrieveByteBufferFromRemoteMachine(InetSocketAddress address, long blockId, long offset, long length) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.connect(address);
        this.LOG.info((Object)("Connected to remote machine " + address + " sent"));
        DataServerMessage sendMsg = DataServerMessage.createBlockRequestMessage(blockId, offset, length);
        while (!sendMsg.finishSending()) {
            sendMsg.send(socketChannel);
        }
        this.LOG.info((Object)("Data " + blockId + " to remote machine " + address + " sent"));
        DataServerMessage recvMsg = DataServerMessage.createBlockResponseMessage(false, blockId);
        while (!recvMsg.isMessageReady()) {
            int numRead = recvMsg.recv(socketChannel);
            if (numRead != -1) continue;
            this.LOG.warn((Object)"Read nothing");
        }
        this.LOG.info((Object)("Data " + blockId + " from remote machine " + address + " received"));
        socketChannel.close();
        if (!recvMsg.isMessageReady()) {
            this.LOG.info((Object)("Data " + blockId + " from remote machine is not ready."));
            return null;
        }
        if (recvMsg.getBlockId() < 0L) {
            this.LOG.info((Object)("Data " + recvMsg.getBlockId() + " is not in remote machine."));
            return null;
        }
        return recvMsg.getReadOnlyData();
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("pos is negative: " + pos);
        }
        this.mRecache = false;
        if (this.mCurrentBuffer != null) {
            this.mReadByte = pos;
            if (this.mBufferStartPosition <= pos && pos < this.mBufferStartPosition + (long)this.mCurrentBuffer.limit()) {
                this.mCurrentBuffer.position((int)(pos - this.mBufferStartPosition));
            } else {
                this.mBufferStartPosition = pos;
                this.updateCurrentBuffer();
            }
        } else {
            if (this.mCheckpointInputStream != null) {
                this.mCheckpointInputStream.close();
            }
            this.setupStreamFromUnderFs(this.mBlockInfo.offset + pos, this.mUFSConf);
        }
    }

    private void setupStreamFromUnderFs(long offset, Object conf) throws IOException {
        String checkpointPath = this.TFS.getUfsPath(this.FILE.FID);
        if (!checkpointPath.equals("")) {
            this.LOG.info((Object)("May stream from underlayer fs: " + checkpointPath));
            UnderFileSystem underfsClient = UnderFileSystem.get(checkpointPath, conf);
            try {
                this.mCheckpointInputStream = underfsClient.open(checkpointPath);
                while (offset > 0L) {
                    long skipped = this.mCheckpointInputStream.skip(offset);
                    offset -= skipped;
                    if (skipped != 0L) continue;
                    throw new IOException("Failed to find the start position " + offset + " for block " + this.mBlockInfo);
                }
            }
            catch (IOException e) {
                this.LOG.error((Object)("Failed to read from checkpoint " + checkpointPath + " for File " + this.FILE.FID + "\n" + e));
                this.mCheckpointInputStream = null;
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long ret = this.mBlockInfo.length - this.mReadByte;
        if (ret > n) {
            ret = n;
        }
        if (this.mCurrentBuffer != null) {
            if ((long)this.mCurrentBuffer.remaining() < ret) {
                this.mBufferStartPosition = this.mReadByte + ret;
                this.updateCurrentBuffer();
            }
            if (this.mCurrentBuffer != null) {
                if (ret > 0L) {
                    if (this.mRecache) {
                        this.mBlockOutStream.cancel();
                    }
                    this.mRecache = false;
                }
                return (int)ret;
            }
            this.setupStreamFromUnderFs(this.mBlockInfo.offset + this.mReadByte, this.mUFSConf);
        }
        long tmp = this.mCheckpointInputStream.skip(ret);
        ret = Math.min(ret, tmp);
        this.mReadByte += ret;
        if (ret > 0L) {
            if (this.mRecache) {
                this.mBlockOutStream.cancel();
            }
            this.mRecache = false;
        }
        return ret;
    }

    private void updateCurrentBuffer() throws IOException {
        long length = BUFFER_SIZE;
        if (this.mBufferStartPosition + length > this.mBlockInfo.length) {
            length = this.mBlockInfo.length - this.mBufferStartPosition;
        }
        this.LOG.info((Object)String.format("Try to find remote worker and read block %d from %d, with len %d", this.mBlockInfo.blockId, this.mBufferStartPosition, length));
        this.mCurrentBuffer = this.readRemoteByteBuffer(this.mBlockInfo, this.mBufferStartPosition, length);
        if (this.mCurrentBuffer == null) {
            this.mBlockInfo = this.TFS.getClientBlockInfo(this.FILE.FID, this.BLOCK_INDEX);
            this.mCurrentBuffer = this.readRemoteByteBuffer(this.mBlockInfo, this.mBufferStartPosition, length);
        }
    }
}

