/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.dialect;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.dialect.AbstractDialect;
import org.thymeleaf.dialect.IExecutionAttributeDialect;
import org.thymeleaf.dialect.IExpressionObjectDialect;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.extras.springsecurity5.dialect.expression.SpringSecurityExpressionObjectFactory;
import org.thymeleaf.extras.springsecurity5.dialect.processor.AuthenticationAttrProcessor;
import org.thymeleaf.extras.springsecurity5.dialect.processor.AuthorizeAclAttrProcessor;
import org.thymeleaf.extras.springsecurity5.dialect.processor.AuthorizeAttrProcessor;
import org.thymeleaf.extras.springsecurity5.dialect.processor.AuthorizeUrlAttrProcessor;
import org.thymeleaf.extras.springsecurity5.util.SpringVersionUtils;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.standard.processor.StandardXmlNsTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import reactor.core.publisher.Mono;

public class SpringSecurityDialect
extends AbstractDialect
implements IProcessorDialect,
IExpressionObjectDialect,
IExecutionAttributeDialect {
    public static final String NAME = "SpringSecurity";
    public static final String DEFAULT_PREFIX = "sec";
    public static final int PROCESSOR_PRECEDENCE = 800;
    private static final IExpressionObjectFactory EXPRESSION_OBJECT_FACTORY = new SpringSecurityExpressionObjectFactory();
    private static final Map<String, Object> EXECUTION_ATTRIBUTES;
    private static final String SECURITY_CONTEXT_EXECUTION_ATTRIBUTE_NAME = "ThymeleafReactiveModelAdditions:thymeleafSpringSecurityContext";
    private static final String CSRF_EXECUTION_ATTRIBUTE_NAME = "ThymeleafReactiveModelAdditions:_csrf";

    public SpringSecurityDialect() {
        super(NAME);
    }

    public String getPrefix() {
        return DEFAULT_PREFIX;
    }

    public int getDialectProcessorPrecedence() {
        return 800;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        TemplateMode[] templateModes;
        LinkedHashSet<IProcessor> processors = new LinkedHashSet<IProcessor>();
        for (TemplateMode templateMode : templateModes = new TemplateMode[]{TemplateMode.HTML, TemplateMode.XML, TemplateMode.TEXT, TemplateMode.JAVASCRIPT, TemplateMode.CSS}) {
            processors.add((IProcessor)new AuthenticationAttrProcessor(templateMode, dialectPrefix));
            processors.add((IProcessor)new AuthorizeAttrProcessor(templateMode, dialectPrefix, "authorize"));
            processors.add((IProcessor)new AuthorizeAttrProcessor(templateMode, dialectPrefix, "authorize-expr"));
            processors.add((IProcessor)new AuthorizeUrlAttrProcessor(templateMode, dialectPrefix));
            processors.add((IProcessor)new AuthorizeAclAttrProcessor(templateMode, dialectPrefix));
            processors.add((IProcessor)new StandardXmlNsTagProcessor(templateMode, dialectPrefix));
        }
        return processors;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return EXPRESSION_OBJECT_FACTORY;
    }

    public Map<String, Object> getExecutionAttributes() {
        return EXECUTION_ATTRIBUTES;
    }

    static {
        if (!SpringVersionUtils.isSpringWebFluxPresent()) {
            EXECUTION_ATTRIBUTES = null;
        } else {
            Function<ServerWebExchange, Object> secCtxInitializer = exchange -> ReactiveSecurityContextHolder.getContext();
            Function<ServerWebExchange, Object> csrfTokenInitializer = exchange -> {
                Mono csrfToken = (Mono)exchange.getAttribute(CsrfToken.class.getName());
                if (csrfToken == null) {
                    return Mono.empty();
                }
                return csrfToken.doOnSuccess(token -> exchange.getAttributes().put("_csrf", token));
            };
            EXECUTION_ATTRIBUTES = new HashMap<String, Object>(3, 1.0f);
            EXECUTION_ATTRIBUTES.put(SECURITY_CONTEXT_EXECUTION_ATTRIBUTE_NAME, secCtxInitializer);
            EXECUTION_ATTRIBUTES.put(CSRF_EXECUTION_ATTRIBUTE_NAME, csrfTokenInitializer);
        }
    }
}

