/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.dialect.processor;

import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.springsecurity5.auth.AclAuthUtils;
import org.thymeleaf.extras.springsecurity5.auth.AuthUtils;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.standard.processor.AbstractStandardConditionalVisibilityTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public final class AuthorizeAclAttrProcessor
extends AbstractStandardConditionalVisibilityTagProcessor {
    public static final int ATTR_PRECEDENCE = 300;
    public static final String ATTR_NAME = "authorize-acl";
    private static final String VALUE_SEPARATOR = "::";

    public AuthorizeAclAttrProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, ATTR_NAME, 300);
    }

    protected boolean isVisible(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue) {
        String attrValue;
        String string = attrValue = attributeValue == null ? null : attributeValue.trim();
        if (attrValue == null || attrValue.length() == 0) {
            return false;
        }
        Authentication authentication = AuthUtils.getAuthenticationObject((IExpressionContext)context);
        if (authentication == null) {
            return false;
        }
        ApplicationContext applicationContext = AuthUtils.getContext((IContext)context);
        IEngineConfiguration configuration = context.getConfiguration();
        int separatorPos = attrValue.lastIndexOf(VALUE_SEPARATOR);
        if (separatorPos == -1) {
            throw new TemplateProcessingException("Could not parse \"" + attributeValue + "\" as an access control list expression. Syntax should be \"[domain object expression] :: [permissions]\"");
        }
        String domainObjectExpression = attrValue.substring(0, separatorPos).trim();
        String permissionsExpression = attrValue.substring(separatorPos + 2).trim();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
        IStandardExpression domainObjectExpr = AuthorizeAclAttrProcessor.getExpressionDefaultToLiteral(expressionParser, (IExpressionContext)context, domainObjectExpression);
        IStandardExpression permissionsExpr = AuthorizeAclAttrProcessor.getExpressionDefaultToLiteral(expressionParser, (IExpressionContext)context, permissionsExpression);
        Object domainObject = domainObjectExpr.execute((IExpressionContext)context);
        Object permissionsObject = permissionsExpr.execute((IExpressionContext)context);
        String permissionsStr = permissionsObject == null ? null : permissionsObject.toString();
        return AclAuthUtils.authorizeUsingAccessControlList((IExpressionContext)context, domainObject, applicationContext, permissionsStr, authentication);
    }

    protected static IStandardExpression getExpressionDefaultToLiteral(IStandardExpressionParser expressionParser, IExpressionContext context, String input) {
        IStandardExpression expression = expressionParser.parseExpression(context, input);
        if (expression == null) {
            return new TextLiteralExpression(input);
        }
        return expression;
    }
}

