/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity5.util;

import java.lang.reflect.Method;
import org.springframework.security.core.SpringSecurityCoreVersion;
import org.thymeleaf.util.ClassLoaderUtils;

public final class SpringSecurityVersionUtils {
    private static final int SPRING_SECURITY_VERSION_MAJOR;
    private static final int SPRING_SECURITY_VERSION_MINOR;

    private static boolean testClassExistence(String className) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(SpringSecurityVersionUtils.class);
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Class<?> getClass(String className) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(SpringSecurityVersionUtils.class);
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static int getSpringSecurityVersionMajor() {
        return SPRING_SECURITY_VERSION_MAJOR;
    }

    public static int getSpringSecurityVersionMinor() {
        return SPRING_SECURITY_VERSION_MINOR;
    }

    public static boolean isSpringSecurity30AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR >= 3;
    }

    public static boolean isSpringSecurity31AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR > 3 || SPRING_SECURITY_VERSION_MAJOR == 3 && SPRING_SECURITY_VERSION_MINOR >= 1;
    }

    public static boolean isSpringSecurity32AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR > 3 || SPRING_SECURITY_VERSION_MAJOR == 3 && SPRING_SECURITY_VERSION_MINOR >= 2;
    }

    public static boolean isSpringSecurity40AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR >= 4;
    }

    public static boolean isSpringSecurity41AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR > 4 || SPRING_SECURITY_VERSION_MAJOR == 4 && SPRING_SECURITY_VERSION_MINOR >= 1;
    }

    public static boolean isSpringSecurity42AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR > 4 || SPRING_SECURITY_VERSION_MAJOR == 4 && SPRING_SECURITY_VERSION_MINOR >= 2;
    }

    public static boolean isSpringSecurity50AtLeast() {
        return SPRING_SECURITY_VERSION_MAJOR >= 5;
    }

    private SpringSecurityVersionUtils() {
    }

    static {
        String springSecurityVersion = SpringSecurityCoreVersion.getVersion();
        String securityCorePackageName = SpringSecurityCoreVersion.class.getPackage().getName();
        String springSecurityPackageName = securityCorePackageName.substring(0, securityCorePackageName.length() - 5);
        if (springSecurityVersion != null) {
            try {
                String versionRemainder = springSecurityVersion;
                int separatorIdx = versionRemainder.indexOf(46);
                SPRING_SECURITY_VERSION_MAJOR = Integer.parseInt(versionRemainder.substring(0, separatorIdx));
                int separator2Idx = versionRemainder.indexOf(46, separatorIdx + 1);
                SPRING_SECURITY_VERSION_MINOR = Integer.parseInt(versionRemainder.substring(separatorIdx + 1, separator2Idx));
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError("Exception during initialization of Spring Security versioning utilities. Identified Spring Security version is '" + springSecurityVersion + "', which does not follow the {major}.{minor}.{...} scheme");
            }
        } else if (SpringSecurityVersionUtils.testClassExistence(springSecurityPackageName + ".web.server.context.SecurityContextServerWebExchange")) {
            SPRING_SECURITY_VERSION_MAJOR = 5;
            SPRING_SECURITY_VERSION_MINOR = 0;
        } else if (SpringSecurityVersionUtils.testClassExistence(springSecurityPackageName + ".jackson2.SecurityJackson2Modules")) {
            SPRING_SECURITY_VERSION_MAJOR = 4;
            SPRING_SECURITY_VERSION_MINOR = 2;
        } else if (SpringSecurityVersionUtils.testClassExistence(springSecurityPackageName + ".core.annotation.AuthenticationPrincipal")) {
            Class<?> authenticationPrincipalClass = SpringSecurityVersionUtils.getClass(springSecurityPackageName + ".core.annotation.AuthenticationPrincipal");
            Method[] methods = authenticationPrincipalClass.getDeclaredMethods();
            boolean hasExpressionAttribute = false;
            for (int i = 0; i < methods.length; ++i) {
                if (!"expression".equals(methods[i].getName())) continue;
                hasExpressionAttribute = true;
            }
            if (hasExpressionAttribute) {
                SPRING_SECURITY_VERSION_MAJOR = 4;
                SPRING_SECURITY_VERSION_MINOR = 1;
            } else {
                SPRING_SECURITY_VERSION_MAJOR = 4;
                SPRING_SECURITY_VERSION_MINOR = 0;
            }
        } else if (SpringSecurityVersionUtils.testClassExistence(springSecurityPackageName + ".access.method.P")) {
            SPRING_SECURITY_VERSION_MAJOR = 3;
            SPRING_SECURITY_VERSION_MINOR = 2;
        } else if (SpringSecurityVersionUtils.testClassExistence(springSecurityPackageName + ".provisioning.MutableUserDetails")) {
            SPRING_SECURITY_VERSION_MAJOR = 3;
            SPRING_SECURITY_VERSION_MINOR = 1;
        } else if (SpringSecurityVersionUtils.testClassExistence(springSecurityPackageName + ".access.expression.method.AbstractExpressionBasedMethodConfigAttribute")) {
            SPRING_SECURITY_VERSION_MAJOR = 3;
            SPRING_SECURITY_VERSION_MINOR = 0;
        } else {
            SPRING_SECURITY_VERSION_MAJOR = 2;
            SPRING_SECURITY_VERSION_MINOR = 0;
        }
    }
}

