/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.acl.basic;

import java.util.Vector;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.acl.AclEntry;
import net.sf.acegisecurity.acl.basic.BasicAclEntry;
import net.sf.acegisecurity.acl.basic.EffectiveAclsResolver;

public class GrantedAuthorityEffectiveAclsResolver
implements EffectiveAclsResolver {
    public AclEntry[] resolveEffectiveAcls(AclEntry[] allAcls, Authentication filteredBy) {
        if (allAcls == null || allAcls.length == 0) {
            return null;
        }
        Vector<AclEntry> list = new Vector<AclEntry>();
        for (int i = 0; i < allAcls.length; ++i) {
            if (!(allAcls[i] instanceof BasicAclEntry)) continue;
            Object recipient = ((BasicAclEntry)allAcls[i]).getRecipient();
            if (filteredBy.getPrincipal().equals(recipient)) {
                list.add(allAcls[i]);
                continue;
            }
            GrantedAuthority[] authorities = filteredBy.getAuthorities();
            if (authorities == null || authorities.length == 0) continue;
            for (int k = 0; k < authorities.length; ++k) {
                if (!authorities[k].equals(recipient)) continue;
                list.add(allAcls[i]);
            }
        }
        if (list.size() > 0) {
            return list.toArray(new BasicAclEntry[0]);
        }
        return null;
    }
}

