/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.acl.basic.cache;

import java.io.Serializable;
import net.sf.acegisecurity.acl.basic.AclObjectIdentity;
import net.sf.acegisecurity.acl.basic.BasicAclEntry;
import net.sf.acegisecurity.acl.basic.BasicAclEntryCache;
import net.sf.acegisecurity.acl.basic.cache.BasicAclEntryHolder;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;

public class EhCacheBasedAclEntryCache
implements BasicAclEntryCache,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache == null ? (class$net$sf$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache = EhCacheBasedAclEntryCache.class$("net.sf.acegisecurity.acl.basic.cache.EhCacheBasedAclEntryCache")) : class$net$sf$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache));
    private static final String CACHE_NAME = "ehCacheBasedAclEntryCache";
    private Cache cache;
    private CacheManager manager;
    private int minutesToIdle = 5;
    static /* synthetic */ Class class$net$sf$acegisecurity$acl$basic$cache$EhCacheBasedAclEntryCache;

    public BasicAclEntry[] getEntriesFromCache(AclObjectIdentity aclObjectIdentity) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)aclObjectIdentity);
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (element == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache miss: " + aclObjectIdentity));
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; object: " + aclObjectIdentity));
        }
        BasicAclEntryHolder holder = (BasicAclEntryHolder)element.getValue();
        return holder.getBasicAclEntries();
    }

    public void setMinutesToIdle(int minutesToIdle) {
        this.minutesToIdle = minutesToIdle;
    }

    public int getMinutesToIdle() {
        return this.minutesToIdle;
    }

    public void afterPropertiesSet() throws Exception {
        if (CacheManager.getInstance().cacheExists(CACHE_NAME)) {
            this.cache = CacheManager.getInstance().getCache(CACHE_NAME);
        } else {
            this.manager = CacheManager.create();
            this.cache = new Cache(CACHE_NAME, Integer.MAX_VALUE, false, false, (long)(this.minutesToIdle * 60), (long)(this.minutesToIdle * 60));
            this.manager.addCache(this.cache);
        }
    }

    public void destroy() throws Exception {
        this.manager.removeCache(CACHE_NAME);
    }

    public void putEntriesInCache(BasicAclEntry[] basicAclEntry) {
        BasicAclEntryHolder holder = new BasicAclEntryHolder(basicAclEntry);
        Element element = new Element((Serializable)basicAclEntry[0].getAclObjectIdentity(), (Serializable)holder);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

