/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.base.composite;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceReferenceDt
extends BaseIdentifiableElement
implements IBaseDatatype,
IBaseReference {
    private static final long serialVersionUID = 1L;
    private static final Logger ourLog = LoggerFactory.getLogger(BaseResourceReferenceDt.class);
    private IBaseResource myResource;

    public BaseResourceReferenceDt() {
    }

    public BaseResourceReferenceDt(IResource theResource) {
        this.myResource = theResource;
        this.setReference(theResource.getId());
    }

    public abstract StringDt getDisplayElement();

    public abstract IdDt getReference();

    @Override
    public IBaseResource getResource() {
        return this.myResource;
    }

    @Override
    protected boolean isBaseEmpty() {
        return super.isBaseEmpty() && this.myResource == null;
    }

    public IBaseResource loadResource(IRestfulClient theClient) {
        if (this.myResource != null) {
            return this.myResource;
        }
        IdDt resourceId = this.getReference();
        if (resourceId == null || StringUtils.isBlank((CharSequence)resourceId.getValue())) {
            throw new IllegalStateException("Reference has no resource ID defined");
        }
        if (StringUtils.isBlank((CharSequence)resourceId.getBaseUrl()) || StringUtils.isBlank((CharSequence)resourceId.getResourceType())) {
            throw new IllegalStateException("Reference is not complete (must be in the form [baseUrl]/[resource type]/[resource ID]) - Reference is: " + resourceId.getValue());
        }
        String resourceUrl = resourceId.getValue();
        ourLog.debug("Loading resource at URL: {}", (Object)resourceUrl);
        RuntimeResourceDefinition definition = theClient.getFhirContext().getResourceDefinition(resourceId.getResourceType());
        Class resourceType = definition.getImplementingClass();
        this.myResource = theClient.fetchResourceFromUrl(resourceType, resourceUrl);
        this.myResource.setId(resourceUrl);
        return this.myResource;
    }

    public abstract BaseResourceReferenceDt setReference(IdDt var1);

    public BaseResourceReferenceDt setReference(IIdType theReference) {
        if (theReference instanceof IdDt) {
            this.setReference((IdDt)theReference);
        } else if (theReference != null) {
            this.setReference(new IdDt(theReference.getValue()));
        } else {
            this.setReference((IdDt)null);
        }
        return this;
    }

    @Override
    public BaseResourceReferenceDt setResource(IBaseResource theResource) {
        this.myResource = theResource;
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("reference", (Object)this.getReference().getValueAsString());
        b.append("loaded", this.getResource() != null);
        return b.toString();
    }
}

