/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.UrlUtil;

public enum PatchTypeEnum {
    JSON_PATCH("application/json-patch+json"),
    XML_PATCH("application/xml-patch+xml");

    private final String myContentType;

    private PatchTypeEnum(String theContentType) {
        this.myContentType = theContentType;
    }

    public String getContentType() {
        return this.myContentType;
    }

    public static PatchTypeEnum forContentTypeOrThrowInvalidRequestException(String theContentType) {
        String contentType = theContentType;
        int semiColonIdx = contentType.indexOf(59);
        if (semiColonIdx != -1) {
            contentType = theContentType.substring(0, semiColonIdx);
        }
        if ("application/json-patch+json".equals(contentType = contentType.trim())) {
            return JSON_PATCH;
        }
        if ("application/xml-patch+xml".equals(contentType)) {
            return XML_PATCH;
        }
        throw new InvalidRequestException("Invalid Content-Type for PATCH operation: " + UrlUtil.sanitizeUrlPart(theContentType));
    }
}

