/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.ICoding;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OrderedDistribution;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.ProdCharacteristic;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.SimpleQuantity;
import org.hl7.fhir.r5.model.Statistic;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SubstanceAmount;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.VirtualServiceDetail;
import org.hl7.fhir.r5.model.XhtmlType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class TypeConvertor {
    public static DataType castToType(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof DataType) {
            return (DataType)b;
        }
        if (b.isMetadataBased()) {
            return ((Element)b).asType();
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Reference");
    }

    public static BooleanType castToBoolean(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof BooleanType) {
            return (BooleanType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Boolean");
    }

    public static IntegerType castToInteger(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof IntegerType) {
            return (IntegerType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Integer");
    }

    public static Integer64Type castToInteger64(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Integer64Type) {
            return (Integer64Type)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Integer");
    }

    public static DecimalType castToDecimal(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof DecimalType) {
            return (DecimalType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new DecimalType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Decimal");
    }

    public static Base64BinaryType castToBase64Binary(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Base64BinaryType) {
            return (Base64BinaryType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Base64Binary");
    }

    public static InstantType castToInstant(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof InstantType) {
            return (InstantType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Instant");
    }

    public static StringType castToString(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof StringType) {
            return (StringType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new StringType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a String");
    }

    public static UriType castToUri(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof UriType) {
            return (UriType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new UriType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public static UrlType castToUrl(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof UrlType) {
            return (UrlType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new UrlType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public static CanonicalType castToCanonical(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof CanonicalType) {
            return (CanonicalType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new CanonicalType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Uri");
    }

    public static DateType castToDate(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof DateType) {
            return (DateType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new DateType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Date");
    }

    public static DateTimeType castToDateTime(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof DateTimeType) {
            return (DateTimeType)b;
        }
        if (b.fhirType().equals("dateTime")) {
            return new DateTimeType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a DateTime");
    }

    public static TimeType castToTime(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof TimeType) {
            return (TimeType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Time");
    }

    public static CodeType castToCode(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof CodeType) {
            return (CodeType)b;
        }
        if (b instanceof PrimitiveType) {
            return new CodeType(b.primitiveValue(), (PrimitiveType)b);
        }
        if (b.isPrimitive()) {
            return new CodeType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Code");
    }

    public static OidType castToOid(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof OidType) {
            return (OidType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Oid");
    }

    public static IdType castToId(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof IdType) {
            return (IdType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Id");
    }

    public static UnsignedIntType castToUnsignedInt(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof UnsignedIntType) {
            return (UnsignedIntType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a UnsignedInt");
    }

    public static PositiveIntType castToPositiveInt(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof PositiveIntType) {
            return (PositiveIntType)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a PositiveInt");
    }

    public static MarkdownType castToMarkdown(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof MarkdownType) {
            return (MarkdownType)b;
        }
        if (b.hasPrimitiveValue()) {
            return new MarkdownType(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Markdown");
    }

    public static Annotation castToAnnotation(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Annotation) {
            return (Annotation)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Annotation");
    }

    public static Dosage castToDosage(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Dosage) {
            return (Dosage)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an DosageInstruction");
    }

    public static Attachment castToAttachment(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Attachment) {
            return (Attachment)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Attachment");
    }

    public static Identifier castToIdentifier(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Identifier) {
            return (Identifier)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Identifier");
    }

    public static CodeableConcept castToCodeableConcept(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof CodeableConcept) {
            return (CodeableConcept)b;
        }
        if (b instanceof Element) {
            return ObjectConverter.readAsCodeableConcept((Element)b);
        }
        if (b instanceof CodeType) {
            CodeableConcept cc = new CodeableConcept();
            cc.addCoding().setCode(((CodeType)b).asStringValue());
            return cc;
        }
        if (b instanceof StringType) {
            CodeableConcept cc = new CodeableConcept();
            cc.addCoding().setCode(((StringType)b).asStringValue());
            return cc;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a CodeableConcept");
    }

    public static CodeableReference castToCodeableReference(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof CodeableReference) {
            return (CodeableReference)b;
        }
        if (b instanceof CodeType) {
            CodeableReference cc = new CodeableReference();
            cc.getConcept().addCoding().setCode(((CodeType)b).asStringValue());
            return cc;
        }
        if (b instanceof Reference) {
            CodeableReference cc = new CodeableReference();
            cc.setReference((Reference)b);
            return cc;
        }
        if (b instanceof StringType) {
            CodeableReference cc = new CodeableReference();
            cc.getConcept().addCoding().setCode(((StringType)b).asStringValue());
            return cc;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a CodeableConcept");
    }

    public static Population castToPopulation(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Population) {
            return (Population)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Population");
    }

    public static Coding castToCoding(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Coding) {
            return (Coding)b;
        }
        if (b instanceof Element) {
            ICoding c = ((Element)b).getAsICoding();
            if (c != null) {
                return new Coding().setCode(c.getCode()).setSystem(c.getSystem()).setVersion(c.getVersion()).setDisplay(c.getDisplay());
            }
            if (b instanceof PrimitiveType) {
                PrimitiveType p = (PrimitiveType)b;
                Coding cc = new Coding();
                cc.setCode(b.primitiveValue()).setId(p.getId()).getExtension().addAll(p.getExtension());
                return cc;
            }
            if (b.isPrimitive()) {
                return new Coding().setCode(b.primitiveValue());
            }
            throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Coding");
        }
        if (b instanceof ICoding) {
            ICoding c = (ICoding)((Object)b);
            return new Coding().setCode(c.getCode()).setSystem(c.getSystem()).setVersion(c.getVersion()).setDisplay(c.getDisplay());
        }
        if (b instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)b;
            Coding cc = new Coding();
            cc.setCode(b.primitiveValue()).setId(p.getId()).getExtension().addAll(p.getExtension());
            return cc;
        }
        if (b.isPrimitive()) {
            return new Coding().setCode(b.primitiveValue());
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Coding");
    }

    public static Quantity castToQuantity(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Quantity) {
            return (Quantity)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Quantity");
    }

    public static Count castToCount(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Count) {
            return (Count)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Count");
    }

    public static Money castToMoney(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Money) {
            return (Money)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Money");
    }

    public static Duration castToDuration(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Duration) {
            return (Duration)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an Duration");
    }

    public static SimpleQuantity castToSimpleQuantity(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof SimpleQuantity) {
            return (SimpleQuantity)b;
        }
        if (b instanceof Quantity) {
            Quantity q = (Quantity)b;
            SimpleQuantity sq = new SimpleQuantity();
            sq.setValueElement(q.getValueElement());
            sq.setComparatorElement(q.getComparatorElement());
            sq.setUnitElement(q.getUnitElement());
            sq.setSystemElement(q.getSystemElement());
            sq.setCodeElement(q.getCodeElement());
            return sq;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to an SimpleQuantity");
    }

    public static Range castToRange(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Range) {
            return (Range)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Range");
    }

    public static Period castToPeriod(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Period) {
            return (Period)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Period");
    }

    public static Ratio castToRatio(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Ratio) {
            return (Ratio)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Ratio");
    }

    public static SampledData castToSampledData(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof SampledData) {
            return (SampledData)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a SampledData");
    }

    public static Signature castToSignature(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Signature) {
            return (Signature)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Signature");
    }

    public static HumanName castToHumanName(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof HumanName) {
            return (HumanName)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a HumanName");
    }

    public static Address castToAddress(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Address) {
            return (Address)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Address");
    }

    public static ContactDetail castToContactDetail(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ContactDetail) {
            return (ContactDetail)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ContactDetail");
    }

    public static Contributor castToContributor(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Contributor) {
            return (Contributor)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Contributor");
    }

    public static UsageContext castToUsageContext(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof UsageContext) {
            return (UsageContext)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a UsageContext");
    }

    public static RelatedArtifact castToRelatedArtifact(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof RelatedArtifact) {
            return (RelatedArtifact)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a RelatedArtifact");
    }

    public static ContactPoint castToContactPoint(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ContactPoint) {
            return (ContactPoint)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ContactPoint");
    }

    public static Timing castToTiming(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Timing) {
            return (Timing)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Timing");
    }

    public static Reference castToReference(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Reference) {
            return (Reference)b;
        }
        if (b.isPrimitive() && Utilities.isURL((String)b.primitiveValue())) {
            return new Reference().setReference(b.primitiveValue());
        }
        if (b instanceof Element && b.fhirType().equals("Reference")) {
            Element e = (Element)b;
            return new Reference().setReference(e.getChildValue("reference")).setDisplay(e.getChildValue("display"));
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Reference");
    }

    public static Meta castToMeta(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Meta) {
            return (Meta)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Meta");
    }

    public static MarketingStatus castToMarketingStatus(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof MarketingStatus) {
            return (MarketingStatus)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a MarketingStatus");
    }

    public static Statistic castToStatistic(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Statistic) {
            return (Statistic)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Statistic");
    }

    public static OrderedDistribution castToOrderedDistribution(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof OrderedDistribution) {
            return (OrderedDistribution)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a OrderedDistribution");
    }

    public static ProductShelfLife castToProductShelfLife(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ProductShelfLife) {
            return (ProductShelfLife)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ProductShelfLife");
    }

    public static ProdCharacteristic castToProdCharacteristic(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ProdCharacteristic) {
            return (ProdCharacteristic)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ProdCharacteristic");
    }

    public static SubstanceAmount castToSubstanceAmount(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof SubstanceAmount) {
            return (SubstanceAmount)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a SubstanceAmount");
    }

    public static Extension castToExtension(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Extension) {
            return (Extension)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Extension");
    }

    public static Resource castToResource(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Resource) {
            return (Resource)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Resource");
    }

    public static Narrative castToNarrative(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Narrative) {
            return (Narrative)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Narrative");
    }

    public static ElementDefinition castToElementDefinition(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ElementDefinition) {
            return (ElementDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ElementDefinition");
    }

    public static DataRequirement castToDataRequirement(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof DataRequirement) {
            return (DataRequirement)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a DataRequirement");
    }

    public static Expression castToExpression(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Expression) {
            return (Expression)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Expression");
    }

    public static ParameterDefinition castToParameterDefinition(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ParameterDefinition) {
            return (ParameterDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ParameterDefinition");
    }

    public static TriggerDefinition castToTriggerDefinition(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof TriggerDefinition) {
            return (TriggerDefinition)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a TriggerDefinition");
    }

    public static ExtendedContactDetail castToExtendedContactDetail(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof ExtendedContactDetail) {
            return (ExtendedContactDetail)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a ExtendedContactDetail");
    }

    public static XhtmlNode castToXhtml(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Element) {
            return ((Element)b).getXhtml();
        }
        if (b instanceof XhtmlType) {
            return ((XhtmlType)b).getXhtml();
        }
        if (b instanceof StringType) {
            try {
                return new XhtmlParser().parseFragment(((StringType)b).asStringValue());
            }
            catch (IOException e) {
                throw new FHIRException((Throwable)e);
            }
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to XHtml");
    }

    public static String castToXhtmlString(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Element) {
            return ((Element)b).getValue();
        }
        if (b instanceof XhtmlType) {
            try {
                return new XhtmlComposer(true).compose(((XhtmlType)b).getXhtml());
            }
            catch (IOException e) {
                return null;
            }
        }
        if (b instanceof StringType) {
            return ((StringType)b).asStringValue();
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to XHtml string");
    }

    public static VirtualServiceDetail castToVirtualServiceDetail(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof VirtualServiceDetail) {
            return (VirtualServiceDetail)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a VirtualServiceDetail");
    }

    public static Availability castToAvailability(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof Availability) {
            return (Availability)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a Availability");
    }

    public static MonetaryComponent castToMonetaryComponent(Base b) throws FHIRException {
        if (b == null) {
            return null;
        }
        if (b instanceof MonetaryComponent) {
            return (MonetaryComponent)b;
        }
        throw new FHIRException("Unable to convert a " + b.getClass().getName() + " to a MonetaryComponent");
    }
}

