/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class CapabilityStatementRenderer
extends ResourceRenderer {
    public CapabilityStatementRenderer(RenderingContext context) {
        super(context);
    }

    public CapabilityStatementRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (CapabilityStatement)dr);
    }

    public boolean render(XhtmlNode x, CapabilityStatement conf) throws FHIRFormatError, DefinitionException, IOException {
        x.h2().addText(conf.getName());
        this.addMarkdown(x, conf.getDescription());
        if (conf.getRest().size() > 0) {
            CapabilityStatement.CapabilityStatementRestComponent rest = conf.getRest().get(0);
            XhtmlNode t = x.table(null);
            if (rest.hasMode()) {
                this.addTableRow(t, "Mode", rest.getMode().toString());
            }
            this.addMarkdown(this.addTableRow(t, "Description"), rest.getDocumentation());
            this.addTableRow(t, "Transaction", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.TRANSACTION));
            this.addTableRow(t, "System History", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM));
            this.addTableRow(t, "System Search", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM));
            boolean hasVRead = false;
            boolean hasPatch = false;
            boolean hasDelete = false;
            boolean hasHistory = false;
            boolean hasUpdates = false;
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                hasVRead = hasVRead || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD);
                hasPatch = hasPatch || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH);
                hasDelete = hasDelete || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE);
                hasHistory = hasHistory || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                hasUpdates = hasUpdates || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
            }
            t = x.table(null);
            XhtmlNode tr = t.tr();
            tr.th().b().tx("Resource Type");
            tr.th().b().tx("Profile");
            tr.th().b().attribute("title", "GET a resource (read interaction)").tx("Read");
            if (hasVRead) {
                tr.th().b().attribute("title", "GET past versions of resources (vread interaction)").tx("V-Read");
            }
            tr.th().b().attribute("title", "GET all set of resources of the type (search interaction)").tx("Search");
            tr.th().b().attribute("title", "PUT a new resource version (update interaction)").tx("Update");
            if (hasPatch) {
                tr.th().b().attribute("title", "PATCH a new resource version (patch interaction)").tx("Patch");
            }
            tr.th().b().attribute("title", "POST a new resource (create interaction)").tx("Create");
            if (hasDelete) {
                tr.th().b().attribute("title", "DELETE a resource (delete interaction)").tx("Delete");
            }
            if (hasUpdates) {
                tr.th().b().attribute("title", "GET changes to a resource (history interaction on instance)").tx("Updates");
            }
            if (hasHistory) {
                tr.th().b().attribute("title", "GET changes for all resources of the type (history interaction on type)").tx("History");
            }
            XhtmlNode profCell = null;
            boolean hasProf = false;
            boolean hasSupProf = false;
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                tr = t.tr();
                tr.td().addText(r.getType());
                profCell = tr.td();
                hasProf = r.hasProfile();
                hasSupProf = r.hasSupportedProfile();
                if (!hasProf && !hasSupProf) {
                    profCell.nbsp();
                } else if (hasProf) {
                    profCell.ah(r.getProfile()).addText(r.getProfile());
                    if (hasSupProf) {
                        profCell.br();
                        profCell.addText("Additional supported profiles:");
                        for (CanonicalType sp : r.getSupportedProfile()) {
                            profCell.br();
                            profCell.nbsp().nbsp();
                            profCell.ah((String)sp.getValue()).addText((String)sp.getValue());
                        }
                    }
                } else {
                    profCell.addText("Supported profiles:");
                    for (CanonicalType sp : r.getSupportedProfile()) {
                        profCell.br();
                        profCell.nbsp().nbsp();
                        profCell.ah((String)sp.getValue()).addText((String)sp.getValue());
                    }
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.READ));
                if (hasVRead) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD));
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE));
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.UPDATE));
                if (hasPatch) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH));
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.CREATE));
                if (hasDelete) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE));
                }
                if (hasUpdates) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE));
                }
                if (!hasHistory) continue;
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE));
            }
        }
        return true;
    }

    public void describe(XhtmlNode x, CapabilityStatement cs) {
        x.tx(this.display(cs));
    }

    public String display(CapabilityStatement cs) {
        return cs.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((CapabilityStatement)r).present();
    }

    private boolean hasOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return true;
        }
        return false;
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatement.SystemRestfulInteraction on) {
        for (CapabilityStatement.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private XhtmlNode addTableRow(XhtmlNode t, String name) {
        XhtmlNode tr = t.tr();
        tr.td().addText(name);
        return tr.td();
    }

    private void addTableRow(XhtmlNode t, String name, String value) {
        XhtmlNode tr = t.tr();
        tr.td().addText(name);
        tr.td().addText(value);
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        if (r.has("name")) {
            return r.children("name").get(0).getBase().primitiveValue();
        }
        return "??";
    }
}

