/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class ListRenderer
extends ResourceRenderer {
    public ListRenderer(RenderingContext context) {
        super(context);
    }

    public ListRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (ListResource)dr);
    }

    @Override
    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper list) throws FHIRFormatError, DefinitionException, IOException {
        if (list.has("title")) {
            x.h2().tx(list.get("title").primitiveValue());
        }
        XhtmlNode t = x.table("clstu");
        XhtmlNode tr = t.tr();
        XhtmlNode td = tr.td();
        if (list.has("date")) {
            td.tx("Date: " + list.get("date").dateTimeValue().toHumanDisplay());
        }
        if (list.has("mode")) {
            td.tx("Mode: " + list.get("mode").primitiveValue());
        }
        if (list.has("status")) {
            td.tx("Status: " + list.get("status").primitiveValue());
        }
        if (list.has("code")) {
            td.tx("Code: " + this.displayBase(list.get("code")));
        }
        tr = t.tr();
        td = tr.td();
        if (list.has("subject")) {
            td.tx("Subject: ");
            this.shortForRef(td, list.get("subject"));
        }
        if (list.has("encounter")) {
            td.tx("Encounter: ");
            this.shortForRef(td, list.get("encounter"));
        }
        if (list.has("source")) {
            td.tx("Source: ");
            this.shortForRef(td, list.get("encounter"));
        }
        if (list.has("orderedBy")) {
            td.tx("Order: " + this.displayBase(list.get("orderedBy")));
        }
        boolean flag = false;
        boolean deleted = false;
        boolean date = false;
        for (BaseWrappers.BaseWrapper e : list.children("entry")) {
            flag = flag || e.has("flag");
            deleted = deleted || e.has("deleted");
            date = date || e.has("date");
        }
        t = x.table("grid");
        tr = t.tr().style("backgound-color: #eeeeee");
        tr.td().b().tx("Items");
        if (date) {
            tr.td().tx("Date");
        }
        if (flag) {
            tr.td().tx("Flag");
        }
        if (deleted) {
            tr.td().tx("Deleted");
        }
        for (BaseWrappers.BaseWrapper e : list.children("entry")) {
            tr = t.tr();
            this.shortForRef(tr.td(), e.get("item"));
            if (date) {
                tr.td().tx(e.has("date") ? e.get("date").dateTimeValue().toHumanDisplay() : "");
            }
            if (flag) {
                tr.td().tx(e.has("flag") ? this.displayBase(e.get("flag")) : "");
            }
            if (!deleted) continue;
            tr.td().tx(e.has("deleted") ? e.get("deleted").primitiveValue() : "");
        }
        return false;
    }

    public boolean render(XhtmlNode x, ListResource list) throws FHIRFormatError, DefinitionException, IOException {
        if (list.hasTitle()) {
            x.h2().tx(list.getTitle());
        }
        XhtmlNode t = x.table("clstu");
        XhtmlNode tr = t.tr();
        if (list.hasDate()) {
            tr.td().tx("Date: " + list.getDate().toLocaleString());
        }
        if (list.hasMode()) {
            tr.td().tx("Mode: " + list.getMode().getDisplay());
        }
        if (list.hasStatus()) {
            tr.td().tx("Status: " + list.getStatus().getDisplay());
        }
        if (list.hasCode()) {
            tr.td().tx("Code: " + this.display(list.getCode()));
        }
        tr = t.tr();
        if (list.hasSubject()) {
            this.shortForRef(tr.td().txN("Subject: "), list.getSubject());
        }
        if (list.hasEncounter()) {
            this.shortForRef(tr.td().txN("Encounter: "), list.getEncounter());
        }
        if (list.hasSource()) {
            this.shortForRef(tr.td().txN("Source: "), list.getEncounter());
        }
        if (list.hasOrderedBy()) {
            tr.td().tx("Order: " + this.display(list.getOrderedBy()));
        }
        for (Annotation a : list.getNote()) {
            this.renderAnnotation(x, a);
        }
        boolean flag = false;
        boolean deleted = false;
        boolean date = false;
        for (ListResource.ListResourceEntryComponent e : list.getEntry()) {
            flag = flag || e.hasFlag();
            deleted = deleted || e.hasDeleted();
            date = date || e.hasDate();
        }
        t = x.table("grid");
        tr = t.tr().style("backgound-color: #eeeeee");
        tr.td().b().tx("Items");
        if (date) {
            tr.td().tx("Date");
        }
        if (flag) {
            tr.td().tx("Flag");
        }
        if (deleted) {
            tr.td().tx("Deleted");
        }
        for (ListResource.ListResourceEntryComponent e : list.getEntry()) {
            tr = t.tr();
            this.shortForRef(tr.td(), e.getItem());
            if (date) {
                tr.td().tx(e.hasDate() ? e.getDate().toLocaleString() : "");
            }
            if (flag) {
                tr.td().tx(e.hasFlag() ? this.display(e.getFlag()) : "");
            }
            if (!deleted) continue;
            tr.td().tx(e.hasDeleted() ? Boolean.toString(e.getDeleted()) : "");
        }
        return false;
    }

    public void describe(XhtmlNode x, ListResource list) {
        x.tx(this.display(list));
    }

    public String display(ListResource list) {
        return list.getTitle();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((ListResource)r).getTitle();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }

    private void shortForRef(XhtmlNode x, Reference ref) throws UnsupportedEncodingException, IOException {
        Resolver.ResourceWithReference r = this.context.getResolver().resolve(this.context, ref.getReference());
        if (r == null) {
            x.tx(this.display(ref));
        } else {
            RendererFactory.factory(r.getResource().getName(), this.context).renderReference(r.getResource(), x, ref);
        }
    }

    private XhtmlNode shortForRef(XhtmlNode x, Base ref) throws UnsupportedEncodingException, IOException {
        if (ref == null) {
            x.tx("(null)");
        } else {
            String disp;
            String string = disp = ref.getChildByName("display") != null && ref.getChildByName("display").hasValues() ? ref.getChildByName("display").getValues().get(0).primitiveValue() : null;
            if (ref.getChildByName("reference").hasValues()) {
                String url = ref.getChildByName("reference").getValues().get(0).primitiveValue();
                if (url.startsWith("#")) {
                    x.tx("?ngen-16a?");
                } else {
                    Resolver.ResourceWithReference r = this.context.getResolver().resolve(this.context, url);
                    if (r == null) {
                        if (disp == null) {
                            disp = url;
                        }
                        x.tx(disp);
                    } else if (r.getResource() != null) {
                        RendererFactory.factory(r.getResource().getName(), this.context).renderReference(r.getResource(), x, (Reference)ref);
                    } else {
                        x.ah(r.getReference()).tx(url);
                    }
                }
            } else if (disp != null) {
                x.tx(disp);
            } else {
                x.tx("?ngen-16?");
            }
        }
        return x;
    }
}

