/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class RequirementsRenderer
extends ResourceRenderer {
    public RequirementsRenderer(RenderingContext context) {
        super(context);
    }

    public RequirementsRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (Requirements)dr);
    }

    public boolean render(XhtmlNode x, Requirements req) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode ul;
        XhtmlNode p;
        if (req.hasActor()) {
            if (req.getActor().size() == 1) {
                ActorDefinition acd = this.context.getWorker().fetchResource(ActorDefinition.class, (String)req.getActor().get(0).getValue(), req);
                p = x.para();
                p.tx("These requirements apply to the actor ");
                if (acd == null) {
                    p.code((String)req.getActor().get(0).getValue());
                } else {
                    p.ah(acd.getUserString("path")).tx(acd.present());
                }
            } else {
                x.para().tx("These requirements apply to the following actors:");
                ul = x.ul();
                for (CanonicalType a : req.getActor()) {
                    ActorDefinition acd = this.context.getWorker().fetchResource(ActorDefinition.class, (String)a.getValue(), req);
                    if (acd == null) {
                        ul.li().code((String)a.getValue());
                        continue;
                    }
                    ul.li().ah(acd.getUserString("path")).tx(acd.present());
                }
            }
        }
        if (req.hasDerivedFrom()) {
            if (req.getDerivedFrom().size() == 1) {
                Requirements reqd = this.context.getWorker().fetchResource(Requirements.class, (String)req.getDerivedFrom().get(0).getValue(), req);
                p = x.para();
                p.tx("These requirements derive from ");
                if (reqd == null) {
                    p.code((String)req.getDerivedFrom().get(0).getValue());
                } else {
                    p.ah(reqd.getUserString("path")).tx(reqd.present());
                }
            } else {
                x.para().tx("These requirements are derived from the following requirements:");
                ul = x.ul();
                for (CanonicalType a : req.getDerivedFrom()) {
                    Requirements reqd = this.context.getWorker().fetchResource(Requirements.class, (String)a.getValue(), req);
                    if (reqd == null) {
                        ul.li().code((String)a.getValue());
                        continue;
                    }
                    ul.li().ah(reqd.getUserString("path")).tx(reqd.present());
                }
            }
        }
        XhtmlNode tbl = x.table("grid");
        for (Requirements.RequirementsStatementComponent stmt : req.getStatement()) {
            Resource r;
            String url;
            XhtmlNode li;
            XhtmlNode tr = tbl.tr();
            String lbl = stmt.hasLabel() ? stmt.getLabel() : stmt.getKey();
            XhtmlNode td = tr.td();
            td.b().an(stmt.getKey());
            td.tx(lbl);
            td = tr.td();
            boolean first = true;
            CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://hl7.org/fhir/conformance-expectation");
            for (Enumeration<Requirements.ConformanceExpectation> t : stmt.getConformance()) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                if (cs != null) {
                    td.ah(cs.getUserString("path") + "#conformance-expectation-" + t.asStringValue()).tx(t.asStringValue().toUpperCase());
                    continue;
                }
                td.tx(t.asStringValue().toUpperCase());
            }
            td = tr.td();
            this.addMarkdown(td, stmt.getRequirement());
            if (!stmt.hasDerivedFrom() && !stmt.hasSatisfiedBy() && !stmt.hasReference() && !stmt.hasSource()) continue;
            td.para().tx("Links:");
            XhtmlNode ul2 = td.ul();
            if (stmt.hasDerivedFrom()) {
                Requirements reqr;
                String string;
                li = ul2.li();
                li.tx("Derived From: ");
                Object url2 = stmt.getDerivedFrom();
                String string2 = string = ((String)url2).contains("#") ? ((String)url2).substring(((String)url2).indexOf("#") + 1) : "";
                if (((String)url2).contains("#")) {
                    url2 = ((String)url2).substring(0, ((String)url2).indexOf("#"));
                }
                if ((reqr = this.context.getWorker().fetchResource(Requirements.class, (String)url2, req)) != null) {
                    Requirements.RequirementsStatementComponent stmtr = reqr.findStatement(string);
                    if (stmtr != null) {
                        li.ah(reqr.getUserString("path") + "#" + string).tx(reqr.present() + " # " + (stmt.hasLabel() ? stmt.getLabel() : stmt.getKey()));
                    } else {
                        li.ah(reqr.getUserString("path") + "#" + string).tx(reqr.present() + " # " + string);
                    }
                } else {
                    li.code(stmt.getDerivedFrom());
                }
            }
            if (stmt.hasSatisfiedBy()) {
                li = ul2.li();
                li.tx("Satisfied By: ");
                first = true;
                for (UrlType urlType : stmt.getSatisfiedBy()) {
                    if (first) {
                        first = false;
                    } else {
                        li.tx(", ");
                    }
                    url = (String)urlType.getValue();
                    if (url.contains("#")) {
                        url = url.substring(0, url.indexOf("#"));
                    }
                    if ((r = this.context.getWorker().fetchResource(Resource.class, url, req)) != null) {
                        String desc = this.getResourceDescription(r, null);
                        li.ah((String)urlType.getValue()).tx(desc);
                        continue;
                    }
                    li.ah((String)urlType.getValue()).tx(url);
                }
            }
            if (stmt.hasReference()) {
                li = ul2.li();
                li.tx("References: ");
                int i = 0;
                for (UrlType c2 : stmt.getSatisfiedBy()) {
                    String url3;
                    if (++i > 1) {
                        li.tx(", ");
                    }
                    if ((url3 = (String)c2.getValue()).contains("#")) {
                        url3 = url3.substring(0, url3.indexOf("#"));
                    }
                    li.ah((String)c2.getValue()).tx(url3);
                }
            }
            if (!stmt.hasSource()) continue;
            li = ul2.li();
            li.tx("Source: ");
            first = true;
            for (Reference reference : stmt.getSource()) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                if (reference.hasReference()) {
                    String desc;
                    url = reference.getReference();
                    if (url.contains("#")) {
                        url = url.substring(0, url.indexOf("#"));
                    }
                    r = this.context.getWorker().fetchResource(Resource.class, url, req);
                    Resolver.ResourceWithReference t = null;
                    if (r == null) {
                        t = this.context.getResolver().resolve(this.context, url);
                    }
                    if (r != null) {
                        desc = this.getResourceDescription(r, reference.getDisplay());
                        li.ah(reference.getReference()).tx(desc);
                        continue;
                    }
                    if (t != null) {
                        desc = this.getResourceDescription(t, reference.getDisplay());
                        li.ah(t.getReference()).tx(desc);
                        continue;
                    }
                    li.ah(reference.getReference()).tx(url);
                    continue;
                }
                if (reference.hasDisplay()) {
                    li.tx(reference.getDisplay());
                    continue;
                }
                li.tx("??");
            }
        }
        return false;
    }

    private String getResourceDescription(Resolver.ResourceWithReference res, String display) throws UnsupportedEncodingException, IOException {
        if (!Utilities.noString((String)display)) {
            return display;
        }
        return RendererFactory.factory(res.getResource(), this.context).display(res.getResource());
    }

    private String getResourceDescription(Resource res, String display) throws UnsupportedEncodingException, IOException {
        if (!Utilities.noString((String)display)) {
            return display;
        }
        if (res instanceof CanonicalResource) {
            return ((CanonicalResource)res).present();
        }
        return RendererFactory.factory(res, this.context).display(res);
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return ((Library)r).present();
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        if (r.has("title")) {
            return r.children("title").get(0).getBase().primitiveValue();
        }
        return "??";
    }
}

