/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.utils;

import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.ElementWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;

public class Resolver {

    public static class ResourceWithReference {
        private String reference;
        private BaseWrappers.ResourceWrapper resource;

        public ResourceWithReference(String reference, BaseWrappers.ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public BaseWrappers.ResourceWrapper getResource() {
            return this.resource;
        }
    }

    public static class ResourceContext {
        private ResourceContext container;
        Resource resource;
        Element element;

        public ResourceContext(ResourceContext container, Resource dr) {
            this.container = container;
            this.resource = dr;
        }

        public ResourceContext(ResourceContext container, Element dr) {
            this.container = container;
            this.element = dr;
        }

        public ResourceContext(ResourceContext container, BaseWrappers.ResourceWrapper rw) {
            this.container = container;
            if (rw instanceof DirectWrappers.ResourceWrapperDirect) {
                this.resource = ((DirectWrappers.ResourceWrapperDirect)rw).getResource();
            } else if (rw instanceof ElementWrappers.ResourceWrapperMetaElement) {
                this.element = ((ElementWrappers.ResourceWrapperMetaElement)rw).getElement();
            }
        }

        public ResourceContext getContainer() {
            return this.container;
        }

        public void setContainer(ResourceContext container) {
            this.container = container;
        }

        public Resource getResource() {
            return this.resource;
        }

        public Element getElement() {
            return this.element;
        }

        public Bundle.BundleEntryComponent resolve(String value) {
            if (value.startsWith("#")) {
                if (this.resource instanceof DomainResource) {
                    DomainResource dr = (DomainResource)this.resource;
                    for (Resource r : dr.getContained()) {
                        if (!r.getId().equals(value.substring(1))) continue;
                        Bundle.BundleEntryComponent be = new Bundle.BundleEntryComponent();
                        be.setResource(r);
                        return be;
                    }
                }
                return null;
            }
            if (this.resource instanceof Bundle) {
                Bundle b = (Bundle)this.resource;
                for (Bundle.BundleEntryComponent be : b.getEntry()) {
                    if (be.hasFullUrl() && be.getFullUrl().equals(value)) {
                        return be;
                    }
                    if (!value.equals(be.getResource().fhirType() + "/" + be.getResource().getId())) continue;
                    return be;
                }
            }
            if (this.resource instanceof Parameters) {
                Parameters pp = (Parameters)this.resource;
                for (Parameters.ParametersParameterComponent p : pp.getParameter()) {
                    if (p.getResource() == null || !value.equals(p.getResource().fhirType() + "/" + p.getResource().getId())) continue;
                    Bundle.BundleEntryComponent be = new Bundle.BundleEntryComponent();
                    be.setResource(p.getResource());
                    return be;
                }
            }
            return this.container != null ? this.container.resolve(value) : null;
        }

        public Element resolveElement(String value, String version) {
            if (value.startsWith("#")) {
                if (this.element != null) {
                    for (Element r : this.element.getChildrenByName("contained")) {
                        if (!r.getChildValue("id").equals(value.substring(1))) continue;
                        return r;
                    }
                }
                return null;
            }
            if (this.element != null) {
                Element res;
                if (this.element.fhirType().equals("Bundle")) {
                    for (Element be : this.element.getChildren("entry")) {
                        res = be.getNamedChild("resource");
                        if (res == null) continue;
                        if (value.equals(be.getChildValue("fullUrl")) && this.checkVersion(version, res)) {
                            return be;
                        }
                        if (!value.equals(res.fhirType() + "/" + res.getChildValue("id")) || !this.checkVersion(version, res)) continue;
                        return be;
                    }
                }
                if (this.element.fhirType().equals("Parameters")) {
                    for (Element p : this.element.getChildren("parameter")) {
                        res = p.getNamedChild("resource");
                        if (res == null || !value.equals(res.fhirType() + "/" + res.getChildValue("id")) || !this.checkVersion(version, res)) continue;
                        return p;
                    }
                }
            }
            return this.container != null ? this.container.resolveElement(value, version) : null;
        }

        private boolean checkVersion(String version, Element res) {
            if (version == null) {
                return true;
            }
            if (!res.hasChild("meta")) {
                return false;
            }
            Element meta = res.getNamedChild("meta");
            return version.equals(meta.getChildValue("version"));
        }
    }

    public static interface IReferenceResolver {
        public ResourceWithReference resolve(RenderingContext var1, String var2);

        public String urlForContained(RenderingContext var1, String var2, String var3, String var4, String var5);
    }
}

