/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;

public class R5Hacker {
    public static void fixR5BrokenResources(IWorkerContext context) {
        for (StructureDefinition sd : context.fetchResourcesByType(StructureDefinition.class)) {
            R5Hacker.fixSD(sd);
        }
    }

    private static void fixSD(StructureDefinition sd) {
        if ("5.0.0-ballot".equals(sd.getVersion()) && "ElementDefinition".equals(sd.getType())) {
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                R5Hacker.hackEDR5BallotError(ed);
            }
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                R5Hacker.hackEDR5BallotError(ed);
            }
        }
        if ("5.0.0-ballot".equals(sd.getVersion()) && "Base".equals(sd.getType())) {
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                R5Hacker.hackBaseR5BallotError(ed);
            }
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                R5Hacker.hackBaseR5BallotError(ed);
            }
        }
        if ("5.0.0-ballot".equals(sd.getVersion()) && "Bundle".equals(sd.getType())) {
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                R5Hacker.hackBundleR5BallotError(ed);
            }
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                R5Hacker.hackBundleR5BallotError(ed);
            }
        }
        if ("5.0.0-ballot".equals(sd.getVersion()) && "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype".equals(sd.getUrl())) {
            sd.getContextFirstRep().setExpression("ElementDefinition");
        }
    }

    private static void hackBaseR5BallotError(ElementDefinition ed) {
        ed.getConstraint().clear();
    }

    private static void hackBundleR5BallotError(ElementDefinition ed) {
        if (ed.getPath().equals("Bundle.link.relation")) {
            ToolingExtensions.removeExtension(ed.getBinding(), "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName");
        }
    }

    private static void hackEDR5BallotError(ElementDefinition ed) {
        if (ed.getPath().equals("ElementDefinition.type.code")) {
            ed.getBinding().setStrength(Enumerations.BindingStrength.EXTENSIBLE);
        }
    }

    public static CanonicalResource fixR5BrokenResource(CanonicalResource cr) {
        if (cr instanceof StructureDefinition) {
            StructureDefinition sd = (StructureDefinition)cr;
            R5Hacker.fixSD(sd);
        }
        return cr;
    }
}

