/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.IOException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;

public class XLIFFProducer
extends LanguageFileProducer {
    private String fileName;
    private StringBuilder xml;
    int i = 0;

    public XLIFFProducer(String folder) {
        super(folder);
    }

    @Override
    public void start(String fileName, String contextId, String contextDesc, String baseLang, String targetLang) {
        this.fileName = fileName;
        this.xml = new StringBuilder();
        this.ln("<?xml version=\"1.0\" ?>\r\n");
        this.ln("<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\">");
        this.ln("  <file source-language=\"" + baseLang + "\" target-language=\"" + targetLang + "\" id=\"" + contextId + "\" original=\"" + contextDesc + "\" datatype=\"KEYVALUEJSON\">");
        this.ln("    <body>");
    }

    @Override
    public void makeEntry(String id, String ref, String context, String source, String target) {
        ++this.i;
        this.ln("      <trans-unit id=\"" + id + "\" resname=\"" + ref + "\">");
        if (context != null) {
            this.ln("        <notes>");
            this.ln("          <note id=\"n" + this.i + "\">" + Utilities.escapeXml(context) + "</note>");
            this.ln("        </notes>");
        }
        this.ln("        <source>" + Utilities.escapeXml(source) + "</source>");
        this.ln("        <target>" + Utilities.escapeXml(target) + "</target>");
        this.ln("      </trans-unit>");
    }

    @Override
    public void finish() throws IOException {
        this.ln("    </body>");
        this.ln("  </file>");
        this.ln("</xliff>");
        TextFile.stringToFile(this.xml.toString(), Utilities.path(this.getFolder(), this.fileName + ".xliff"));
    }

    protected void ln(String line) {
        this.xml.append(line + "\r\n");
    }
}

