/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;

public class KinesisClientLibConfiguration {
    private static final long EPSILON_MS = 25L;
    public static final long DEFAULT_FAILOVER_TIME_MILLIS = 10000L;
    public static final int DEFAULT_MAX_RECORDS = 10000;
    public static final long DEFAULT_IDLETIME_BETWEEN_READS_MILLIS = 1000L;
    public static final boolean DEFAULT_DONT_CALL_PROCESS_RECORDS_FOR_EMPTY_RECORD_LIST = false;
    public static final long DEFAULT_PARENT_SHARD_POLL_INTERVAL_MILLIS = 10000L;
    public static final long DEFAULT_SHARD_SYNC_INTERVAL_MILLIS = 60000L;
    public static final boolean DEFAULT_CLEANUP_LEASES_UPON_SHARDS_COMPLETION = true;
    public static final long DEFAULT_TASK_BACKOFF_TIME_MILLIS = 500L;
    public static final long DEFAULT_METRICS_BUFFER_TIME_MILLIS = 10000L;
    public static final int DEFAULT_METRICS_MAX_QUEUE_SIZE = 10000;
    public static final String KINESIS_CLIENT_LIB_USER_AGENT = "amazon-kinesis-client-library-java-1.4.0";
    public static final boolean DEFAULT_VALIDATE_SEQUENCE_NUMBER_BEFORE_CHECKPOINTING = true;
    private String applicationName;
    private String streamName;
    private String kinesisEndpoint;
    private InitialPositionInStream initialPositionInStream;
    private AWSCredentialsProvider kinesisCredentialsProvider;
    private AWSCredentialsProvider dynamoDBCredentialsProvider;
    private AWSCredentialsProvider cloudWatchCredentialsProvider;
    private long failoverTimeMillis;
    private String workerIdentifier;
    private long shardSyncIntervalMillis;
    private int maxRecords;
    private long idleTimeBetweenReadsInMillis;
    private boolean callProcessRecordsEvenForEmptyRecordList;
    private long parentShardPollIntervalMillis;
    private boolean cleanupLeasesUponShardCompletion;
    private ClientConfiguration kinesisClientConfig;
    private ClientConfiguration dynamoDBClientConfig;
    private ClientConfiguration cloudWatchClientConfig;
    private long taskBackoffTimeMillis;
    private long metricsBufferTimeMillis;
    private int metricsMaxQueueSize;
    private boolean validateSequenceNumberBeforeCheckpointing;
    private String regionName;

    public KinesisClientLibConfiguration(String applicationName, String streamName, AWSCredentialsProvider credentialsProvider, String workerId) {
        this(applicationName, streamName, credentialsProvider, credentialsProvider, credentialsProvider, workerId);
    }

    public KinesisClientLibConfiguration(String applicationName, String streamName, AWSCredentialsProvider kinesisCredentialsProvider, AWSCredentialsProvider dynamoDBCredentialsProvider, AWSCredentialsProvider cloudWatchCredentialsProvider, String workerId) {
        this(applicationName, streamName, null, InitialPositionInStream.LATEST, kinesisCredentialsProvider, dynamoDBCredentialsProvider, cloudWatchCredentialsProvider, 10000L, workerId, 10000, 1000L, false, 10000L, 60000L, true, new ClientConfiguration(), new ClientConfiguration(), new ClientConfiguration(), 500L, 10000L, 10000, true, null);
    }

    public KinesisClientLibConfiguration(String applicationName, String streamName, String kinesisEndpoint, InitialPositionInStream initialPositionInStream, AWSCredentialsProvider kinesisCredentialsProvider, AWSCredentialsProvider dynamoDBCredentialsProvider, AWSCredentialsProvider cloudWatchCredentialsProvider, long failoverTimeMillis, String workerId, int maxRecords, long idleTimeBetweenReadsInMillis, boolean callProcessRecordsEvenForEmptyRecordList, long parentShardPollIntervalMillis, long shardSyncIntervalMillis, boolean cleanupTerminatedShardsBeforeExpiry, ClientConfiguration kinesisClientConfig, ClientConfiguration dynamoDBClientConfig, ClientConfiguration cloudWatchClientConfig, long taskBackoffTimeMillis, long metricsBufferTimeMillis, int metricsMaxQueueSize, boolean validateSequenceNumberBeforeCheckpointing, String regionName) {
        this.checkIsValuePositive("FailoverTimeMillis", failoverTimeMillis);
        this.checkIsValuePositive("IdleTimeBetweenReadsInMillis", idleTimeBetweenReadsInMillis);
        this.checkIsValuePositive("ParentShardPollIntervalMillis", parentShardPollIntervalMillis);
        this.checkIsValuePositive("ShardSyncIntervalMillis", shardSyncIntervalMillis);
        this.checkIsValuePositive("MaxRecords", maxRecords);
        this.checkIsValuePositive("TaskBackoffTimeMillis", taskBackoffTimeMillis);
        this.checkIsValuePositive("MetricsBufferTimeMills", metricsBufferTimeMillis);
        this.checkIsValuePositive("MetricsMaxQueueSize", metricsMaxQueueSize);
        this.checkIsRegionNameValid(regionName);
        this.applicationName = applicationName;
        this.streamName = streamName;
        this.kinesisEndpoint = kinesisEndpoint;
        this.initialPositionInStream = initialPositionInStream;
        this.kinesisCredentialsProvider = kinesisCredentialsProvider;
        this.dynamoDBCredentialsProvider = dynamoDBCredentialsProvider;
        this.cloudWatchCredentialsProvider = cloudWatchCredentialsProvider;
        this.failoverTimeMillis = failoverTimeMillis;
        this.maxRecords = maxRecords;
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        this.cleanupLeasesUponShardCompletion = cleanupTerminatedShardsBeforeExpiry;
        this.workerIdentifier = workerId;
        this.kinesisClientConfig = this.checkAndAppendKinesisClientLibUserAgent(kinesisClientConfig);
        this.dynamoDBClientConfig = this.checkAndAppendKinesisClientLibUserAgent(dynamoDBClientConfig);
        this.cloudWatchClientConfig = this.checkAndAppendKinesisClientLibUserAgent(cloudWatchClientConfig);
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
        this.metricsMaxQueueSize = metricsMaxQueueSize;
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
        this.regionName = regionName;
    }

    private void checkIsValuePositive(String key, long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("Value of " + key + " should be positive, but current value is " + value);
        }
    }

    private ClientConfiguration checkAndAppendKinesisClientLibUserAgent(ClientConfiguration config) {
        String existingUserAgent = config.getUserAgent();
        if (existingUserAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            existingUserAgent = this.applicationName;
        }
        if (!existingUserAgent.contains(KINESIS_CLIENT_LIB_USER_AGENT)) {
            existingUserAgent = existingUserAgent + ",amazon-kinesis-client-library-java-1.4.0";
        }
        config.setUserAgent(existingUserAgent);
        return config;
    }

    private void checkIsRegionNameValid(String regionNameToCheck) {
        if (regionNameToCheck != null && RegionUtils.getRegion((String)regionNameToCheck) == null) {
            throw new IllegalArgumentException("The specified region name is not valid");
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public long getFailoverTimeMillis() {
        return this.failoverTimeMillis;
    }

    public AWSCredentialsProvider getKinesisCredentialsProvider() {
        return this.kinesisCredentialsProvider;
    }

    public AWSCredentialsProvider getDynamoDBCredentialsProvider() {
        return this.dynamoDBCredentialsProvider;
    }

    public AWSCredentialsProvider getCloudWatchCredentialsProvider() {
        return this.cloudWatchCredentialsProvider;
    }

    public String getWorkerIdentifier() {
        return this.workerIdentifier;
    }

    public long getShardSyncIntervalMillis() {
        return this.shardSyncIntervalMillis;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public long getIdleTimeBetweenReadsInMillis() {
        return this.idleTimeBetweenReadsInMillis;
    }

    boolean shouldCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    public long getEpsilonMillis() {
        return 25L;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getKinesisEndpoint() {
        return this.kinesisEndpoint;
    }

    public InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }

    public long getParentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    public ClientConfiguration getKinesisClientConfiguration() {
        return this.kinesisClientConfig;
    }

    public ClientConfiguration getDynamoDBClientConfiguration() {
        return this.dynamoDBClientConfig;
    }

    public ClientConfiguration getCloudWatchClientConfiguration() {
        return this.cloudWatchClientConfig;
    }

    public long getTaskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    public long getMetricsBufferTimeMillis() {
        return this.metricsBufferTimeMillis;
    }

    public int getMetricsMaxQueueSize() {
        return this.metricsMaxQueueSize;
    }

    public boolean shouldCleanupLeasesUponShardCompletion() {
        return this.cleanupLeasesUponShardCompletion;
    }

    public boolean shouldValidateSequenceNumberBeforeCheckpointing() {
        return this.validateSequenceNumberBeforeCheckpointing;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public KinesisClientLibConfiguration withKinesisEndpoint(String kinesisEndpoint) {
        this.kinesisEndpoint = kinesisEndpoint;
        return this;
    }

    public KinesisClientLibConfiguration withInitialPositionInStream(InitialPositionInStream initialPositionInStream) {
        this.initialPositionInStream = initialPositionInStream;
        return this;
    }

    public KinesisClientLibConfiguration withFailoverTimeMillis(long failoverTimeMillis) {
        this.checkIsValuePositive("FailoverTimeMillis", failoverTimeMillis);
        this.failoverTimeMillis = failoverTimeMillis;
        return this;
    }

    public KinesisClientLibConfiguration withShardSyncIntervalMillis(long shardSyncIntervalMillis) {
        this.checkIsValuePositive("ShardSyncIntervalMillis", shardSyncIntervalMillis);
        this.shardSyncIntervalMillis = shardSyncIntervalMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMaxRecords(int maxRecords) {
        this.checkIsValuePositive("MaxRecords", maxRecords);
        this.maxRecords = maxRecords;
        return this;
    }

    public KinesisClientLibConfiguration withIdleTimeBetweenReadsInMillis(long idleTimeBetweenReadsInMillis) {
        this.checkIsValuePositive("IdleTimeBetweenReadsInMillis", idleTimeBetweenReadsInMillis);
        this.idleTimeBetweenReadsInMillis = idleTimeBetweenReadsInMillis;
        return this;
    }

    public KinesisClientLibConfiguration withCallProcessRecordsEvenForEmptyRecordList(boolean callProcessRecordsEvenForEmptyRecordList) {
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        return this;
    }

    public KinesisClientLibConfiguration withParentShardPollIntervalMillis(long parentShardPollIntervalMillis) {
        this.checkIsValuePositive("ParentShardPollIntervalMillis", parentShardPollIntervalMillis);
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        return this;
    }

    public KinesisClientLibConfiguration withCleanupLeasesUponShardCompletion(boolean cleanupLeasesUponShardCompletion) {
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        return this;
    }

    public KinesisClientLibConfiguration withCommonClientConfig(ClientConfiguration clientConfig) {
        ClientConfiguration tempClientConfig;
        this.kinesisClientConfig = tempClientConfig = this.checkAndAppendKinesisClientLibUserAgent(clientConfig);
        this.dynamoDBClientConfig = tempClientConfig;
        this.cloudWatchClientConfig = tempClientConfig;
        return this;
    }

    public KinesisClientLibConfiguration withKinesisClientConfig(ClientConfiguration kinesisClientConfig) {
        this.kinesisClientConfig = this.checkAndAppendKinesisClientLibUserAgent(kinesisClientConfig);
        return this;
    }

    public KinesisClientLibConfiguration withDynamoDBClientConfig(ClientConfiguration dynamoDBClientConfig) {
        this.dynamoDBClientConfig = this.checkAndAppendKinesisClientLibUserAgent(dynamoDBClientConfig);
        return this;
    }

    public KinesisClientLibConfiguration withCloudWatchClientConfig(ClientConfiguration cloudWatchClientConfig) {
        this.cloudWatchClientConfig = this.checkAndAppendKinesisClientLibUserAgent(cloudWatchClientConfig);
        return this;
    }

    public KinesisClientLibConfiguration withUserAgent(String userAgent) {
        String customizedUserAgent = userAgent + "," + KINESIS_CLIENT_LIB_USER_AGENT;
        this.kinesisClientConfig.setUserAgent(customizedUserAgent);
        this.dynamoDBClientConfig.setUserAgent(customizedUserAgent);
        this.cloudWatchClientConfig.setUserAgent(customizedUserAgent);
        return this;
    }

    public KinesisClientLibConfiguration withTaskBackoffTimeMillis(long taskBackoffTimeMillis) {
        this.checkIsValuePositive("TaskBackoffTimeMillis", taskBackoffTimeMillis);
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMetricsBufferTimeMillis(long metricsBufferTimeMillis) {
        this.checkIsValuePositive("MetricsBufferTimeMillis", metricsBufferTimeMillis);
        this.metricsBufferTimeMillis = metricsBufferTimeMillis;
        return this;
    }

    public KinesisClientLibConfiguration withMetricsMaxQueueSize(int metricsMaxQueueSize) {
        this.checkIsValuePositive("MetricsMaxQueueSize", metricsMaxQueueSize);
        this.metricsMaxQueueSize = metricsMaxQueueSize;
        return this;
    }

    public KinesisClientLibConfiguration withValidateSequenceNumberBeforeCheckpointing(boolean validateSequenceNumberBeforeCheckpointing) {
        this.validateSequenceNumberBeforeCheckpointing = validateSequenceNumberBeforeCheckpointing;
        return this;
    }

    public KinesisClientLibConfiguration withRegionName(String regionName) {
        this.checkIsRegionNameValid(regionName);
        this.regionName = regionName;
        return this;
    }
}

