/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.proxies;

import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public class MetricsCollectingKinesisProxyDecorator
implements IKinesisProxy {
    private static final String SEP = ".";
    private final String getIteratorMetric;
    private final String getRecordsMetric;
    private final String getStreamInfoMetric;
    private final String getShardListMetric;
    private final String putRecordMetric;
    private final String getRecordsShardId;
    private IKinesisProxy other;

    public MetricsCollectingKinesisProxyDecorator(String prefix, IKinesisProxy other, String shardId) {
        this.other = other;
        this.getRecordsShardId = shardId;
        this.getIteratorMetric = prefix + SEP + "getIterator";
        this.getRecordsMetric = prefix + SEP + "getRecords";
        this.getStreamInfoMetric = prefix + SEP + "getStreamInfo";
        this.getShardListMetric = prefix + SEP + "getShardList";
        this.putRecordMetric = prefix + SEP + "putRecord";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecordsResult get(String shardIterator, int maxRecords) throws ResourceNotFoundException, InvalidArgumentException, ExpiredIteratorException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            GetRecordsResult response = this.other.get(shardIterator, maxRecords);
            success = true;
            GetRecordsResult getRecordsResult = response;
            return getRecordsResult;
        }
        finally {
            MetricsHelper.addSuccessAndLatencyPerShard(this.getRecordsShardId, this.getRecordsMetric, startTime, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStreamResult getStreamInfo(String startingShardId) throws ResourceNotFoundException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            DescribeStreamResult response = this.other.getStreamInfo(startingShardId);
            success = true;
            DescribeStreamResult describeStreamResult = response;
            return describeStreamResult;
        }
        finally {
            MetricsHelper.addSuccessAndLatency(this.getStreamInfoMetric, startTime, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllShardIds() throws ResourceNotFoundException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            Set<String> response = this.other.getAllShardIds();
            success = true;
            Set<String> set = response;
            return set;
        }
        finally {
            MetricsHelper.addSuccessAndLatency(this.getStreamInfoMetric, startTime, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIterator(String shardId, String iteratorEnum, String sequenceNumber) throws ResourceNotFoundException, InvalidArgumentException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            String response = this.other.getIterator(shardId, iteratorEnum, sequenceNumber);
            success = true;
            String string = response;
            return string;
        }
        finally {
            MetricsHelper.addSuccessAndLatency(this.getIteratorMetric, startTime, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Shard> getShardList() throws ResourceNotFoundException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            List<Shard> response = this.other.getShardList();
            success = true;
            List<Shard> list = response;
            return list;
        }
        finally {
            MetricsHelper.addSuccessAndLatency(this.getShardListMetric, startTime, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordResult put(String sequenceNumberForOrdering, String explicitHashKey, String partitionKey, ByteBuffer data) throws ResourceNotFoundException, InvalidArgumentException {
        long startTime = System.currentTimeMillis();
        boolean success = false;
        try {
            PutRecordResult response = this.other.put(sequenceNumberForOrdering, explicitHashKey, partitionKey, data);
            success = true;
            PutRecordResult putRecordResult = response;
            return putRecordResult;
        }
        finally {
            MetricsHelper.addSuccessAndLatency(this.putRecordMetric, startTime, success);
        }
    }
}

