/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.ServerProcess;
import com.amazonaws.services.gamelift.model.transform.RuntimeConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuntimeConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ServerProcess> serverProcesses;
    private Integer maxConcurrentGameSessionActivations;
    private Integer gameSessionActivationTimeoutSeconds;

    public List<ServerProcess> getServerProcesses() {
        return this.serverProcesses;
    }

    public void setServerProcesses(Collection<ServerProcess> serverProcesses) {
        if (serverProcesses == null) {
            this.serverProcesses = null;
            return;
        }
        this.serverProcesses = new ArrayList<ServerProcess>(serverProcesses);
    }

    public RuntimeConfiguration withServerProcesses(ServerProcess ... serverProcesses) {
        if (this.serverProcesses == null) {
            this.setServerProcesses(new ArrayList<ServerProcess>(serverProcesses.length));
        }
        for (ServerProcess ele : serverProcesses) {
            this.serverProcesses.add(ele);
        }
        return this;
    }

    public RuntimeConfiguration withServerProcesses(Collection<ServerProcess> serverProcesses) {
        this.setServerProcesses(serverProcesses);
        return this;
    }

    public void setMaxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
        this.maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations;
    }

    public Integer getMaxConcurrentGameSessionActivations() {
        return this.maxConcurrentGameSessionActivations;
    }

    public RuntimeConfiguration withMaxConcurrentGameSessionActivations(Integer maxConcurrentGameSessionActivations) {
        this.setMaxConcurrentGameSessionActivations(maxConcurrentGameSessionActivations);
        return this;
    }

    public void setGameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
        this.gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds;
    }

    public Integer getGameSessionActivationTimeoutSeconds() {
        return this.gameSessionActivationTimeoutSeconds;
    }

    public RuntimeConfiguration withGameSessionActivationTimeoutSeconds(Integer gameSessionActivationTimeoutSeconds) {
        this.setGameSessionActivationTimeoutSeconds(gameSessionActivationTimeoutSeconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServerProcesses() != null) {
            sb.append("ServerProcesses: ").append(this.getServerProcesses()).append(",");
        }
        if (this.getMaxConcurrentGameSessionActivations() != null) {
            sb.append("MaxConcurrentGameSessionActivations: ").append(this.getMaxConcurrentGameSessionActivations()).append(",");
        }
        if (this.getGameSessionActivationTimeoutSeconds() != null) {
            sb.append("GameSessionActivationTimeoutSeconds: ").append(this.getGameSessionActivationTimeoutSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeConfiguration)) {
            return false;
        }
        RuntimeConfiguration other = (RuntimeConfiguration)obj;
        if (other.getServerProcesses() == null ^ this.getServerProcesses() == null) {
            return false;
        }
        if (other.getServerProcesses() != null && !other.getServerProcesses().equals(this.getServerProcesses())) {
            return false;
        }
        if (other.getMaxConcurrentGameSessionActivations() == null ^ this.getMaxConcurrentGameSessionActivations() == null) {
            return false;
        }
        if (other.getMaxConcurrentGameSessionActivations() != null && !other.getMaxConcurrentGameSessionActivations().equals(this.getMaxConcurrentGameSessionActivations())) {
            return false;
        }
        if (other.getGameSessionActivationTimeoutSeconds() == null ^ this.getGameSessionActivationTimeoutSeconds() == null) {
            return false;
        }
        return other.getGameSessionActivationTimeoutSeconds() == null || other.getGameSessionActivationTimeoutSeconds().equals(this.getGameSessionActivationTimeoutSeconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServerProcesses() == null ? 0 : this.getServerProcesses().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrentGameSessionActivations() == null ? 0 : this.getMaxConcurrentGameSessionActivations().hashCode());
        hashCode = 31 * hashCode + (this.getGameSessionActivationTimeoutSeconds() == null ? 0 : this.getGameSessionActivationTimeoutSeconds().hashCode());
        return hashCode;
    }

    public RuntimeConfiguration clone() {
        try {
            return (RuntimeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuntimeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

