/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediapackagevod.AWSMediaPackageVodAsync;
import com.amazonaws.services.mediapackagevod.AWSMediaPackageVodAsyncClientBuilder;
import com.amazonaws.services.mediapackagevod.AWSMediaPackageVodClient;
import com.amazonaws.services.mediapackagevod.model.CreateAssetRequest;
import com.amazonaws.services.mediapackagevod.model.CreateAssetResult;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingConfigurationRequest;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingConfigurationResult;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingGroupResult;
import com.amazonaws.services.mediapackagevod.model.DeleteAssetRequest;
import com.amazonaws.services.mediapackagevod.model.DeleteAssetResult;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingConfigurationRequest;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingConfigurationResult;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingGroupResult;
import com.amazonaws.services.mediapackagevod.model.DescribeAssetRequest;
import com.amazonaws.services.mediapackagevod.model.DescribeAssetResult;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingConfigurationRequest;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingConfigurationResult;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingGroupResult;
import com.amazonaws.services.mediapackagevod.model.ListAssetsRequest;
import com.amazonaws.services.mediapackagevod.model.ListAssetsResult;
import com.amazonaws.services.mediapackagevod.model.ListPackagingConfigurationsRequest;
import com.amazonaws.services.mediapackagevod.model.ListPackagingConfigurationsResult;
import com.amazonaws.services.mediapackagevod.model.ListPackagingGroupsRequest;
import com.amazonaws.services.mediapackagevod.model.ListPackagingGroupsResult;
import com.amazonaws.services.mediapackagevod.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediapackagevod.model.ListTagsForResourceResult;
import com.amazonaws.services.mediapackagevod.model.TagResourceRequest;
import com.amazonaws.services.mediapackagevod.model.TagResourceResult;
import com.amazonaws.services.mediapackagevod.model.UntagResourceRequest;
import com.amazonaws.services.mediapackagevod.model.UntagResourceResult;
import com.amazonaws.services.mediapackagevod.model.UpdatePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.UpdatePackagingGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaPackageVodAsyncClient
extends AWSMediaPackageVodClient
implements AWSMediaPackageVodAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaPackageVodAsyncClientBuilder asyncBuilder() {
        return AWSMediaPackageVodAsyncClientBuilder.standard();
    }

    AWSMediaPackageVodAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaPackageVodAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateAssetResult> createAssetAsync(CreateAssetRequest request) {
        return this.createAssetAsync(request, null);
    }

    @Override
    public Future<CreateAssetResult> createAssetAsync(CreateAssetRequest request, final AsyncHandler<CreateAssetRequest, CreateAssetResult> asyncHandler) {
        final CreateAssetRequest finalRequest = (CreateAssetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAssetResult>(){

            @Override
            public CreateAssetResult call() throws Exception {
                CreateAssetResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeCreateAsset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePackagingConfigurationResult> createPackagingConfigurationAsync(CreatePackagingConfigurationRequest request) {
        return this.createPackagingConfigurationAsync(request, null);
    }

    @Override
    public Future<CreatePackagingConfigurationResult> createPackagingConfigurationAsync(CreatePackagingConfigurationRequest request, final AsyncHandler<CreatePackagingConfigurationRequest, CreatePackagingConfigurationResult> asyncHandler) {
        final CreatePackagingConfigurationRequest finalRequest = (CreatePackagingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePackagingConfigurationResult>(){

            @Override
            public CreatePackagingConfigurationResult call() throws Exception {
                CreatePackagingConfigurationResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeCreatePackagingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePackagingGroupResult> createPackagingGroupAsync(CreatePackagingGroupRequest request) {
        return this.createPackagingGroupAsync(request, null);
    }

    @Override
    public Future<CreatePackagingGroupResult> createPackagingGroupAsync(CreatePackagingGroupRequest request, final AsyncHandler<CreatePackagingGroupRequest, CreatePackagingGroupResult> asyncHandler) {
        final CreatePackagingGroupRequest finalRequest = (CreatePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePackagingGroupResult>(){

            @Override
            public CreatePackagingGroupResult call() throws Exception {
                CreatePackagingGroupResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeCreatePackagingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request) {
        return this.deleteAssetAsync(request, null);
    }

    @Override
    public Future<DeleteAssetResult> deleteAssetAsync(DeleteAssetRequest request, final AsyncHandler<DeleteAssetRequest, DeleteAssetResult> asyncHandler) {
        final DeleteAssetRequest finalRequest = (DeleteAssetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAssetResult>(){

            @Override
            public DeleteAssetResult call() throws Exception {
                DeleteAssetResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeDeleteAsset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePackagingConfigurationResult> deletePackagingConfigurationAsync(DeletePackagingConfigurationRequest request) {
        return this.deletePackagingConfigurationAsync(request, null);
    }

    @Override
    public Future<DeletePackagingConfigurationResult> deletePackagingConfigurationAsync(DeletePackagingConfigurationRequest request, final AsyncHandler<DeletePackagingConfigurationRequest, DeletePackagingConfigurationResult> asyncHandler) {
        final DeletePackagingConfigurationRequest finalRequest = (DeletePackagingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePackagingConfigurationResult>(){

            @Override
            public DeletePackagingConfigurationResult call() throws Exception {
                DeletePackagingConfigurationResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeDeletePackagingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePackagingGroupResult> deletePackagingGroupAsync(DeletePackagingGroupRequest request) {
        return this.deletePackagingGroupAsync(request, null);
    }

    @Override
    public Future<DeletePackagingGroupResult> deletePackagingGroupAsync(DeletePackagingGroupRequest request, final AsyncHandler<DeletePackagingGroupRequest, DeletePackagingGroupResult> asyncHandler) {
        final DeletePackagingGroupRequest finalRequest = (DeletePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePackagingGroupResult>(){

            @Override
            public DeletePackagingGroupResult call() throws Exception {
                DeletePackagingGroupResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeDeletePackagingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssetResult> describeAssetAsync(DescribeAssetRequest request) {
        return this.describeAssetAsync(request, null);
    }

    @Override
    public Future<DescribeAssetResult> describeAssetAsync(DescribeAssetRequest request, final AsyncHandler<DescribeAssetRequest, DescribeAssetResult> asyncHandler) {
        final DescribeAssetRequest finalRequest = (DescribeAssetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAssetResult>(){

            @Override
            public DescribeAssetResult call() throws Exception {
                DescribeAssetResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeDescribeAsset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePackagingConfigurationResult> describePackagingConfigurationAsync(DescribePackagingConfigurationRequest request) {
        return this.describePackagingConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribePackagingConfigurationResult> describePackagingConfigurationAsync(DescribePackagingConfigurationRequest request, final AsyncHandler<DescribePackagingConfigurationRequest, DescribePackagingConfigurationResult> asyncHandler) {
        final DescribePackagingConfigurationRequest finalRequest = (DescribePackagingConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePackagingConfigurationResult>(){

            @Override
            public DescribePackagingConfigurationResult call() throws Exception {
                DescribePackagingConfigurationResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeDescribePackagingConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePackagingGroupResult> describePackagingGroupAsync(DescribePackagingGroupRequest request) {
        return this.describePackagingGroupAsync(request, null);
    }

    @Override
    public Future<DescribePackagingGroupResult> describePackagingGroupAsync(DescribePackagingGroupRequest request, final AsyncHandler<DescribePackagingGroupRequest, DescribePackagingGroupResult> asyncHandler) {
        final DescribePackagingGroupRequest finalRequest = (DescribePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePackagingGroupResult>(){

            @Override
            public DescribePackagingGroupResult call() throws Exception {
                DescribePackagingGroupResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeDescribePackagingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssetsResult> listAssetsAsync(ListAssetsRequest request) {
        return this.listAssetsAsync(request, null);
    }

    @Override
    public Future<ListAssetsResult> listAssetsAsync(ListAssetsRequest request, final AsyncHandler<ListAssetsRequest, ListAssetsResult> asyncHandler) {
        final ListAssetsRequest finalRequest = (ListAssetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssetsResult>(){

            @Override
            public ListAssetsResult call() throws Exception {
                ListAssetsResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeListAssets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPackagingConfigurationsResult> listPackagingConfigurationsAsync(ListPackagingConfigurationsRequest request) {
        return this.listPackagingConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListPackagingConfigurationsResult> listPackagingConfigurationsAsync(ListPackagingConfigurationsRequest request, final AsyncHandler<ListPackagingConfigurationsRequest, ListPackagingConfigurationsResult> asyncHandler) {
        final ListPackagingConfigurationsRequest finalRequest = (ListPackagingConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPackagingConfigurationsResult>(){

            @Override
            public ListPackagingConfigurationsResult call() throws Exception {
                ListPackagingConfigurationsResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeListPackagingConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPackagingGroupsResult> listPackagingGroupsAsync(ListPackagingGroupsRequest request) {
        return this.listPackagingGroupsAsync(request, null);
    }

    @Override
    public Future<ListPackagingGroupsResult> listPackagingGroupsAsync(ListPackagingGroupsRequest request, final AsyncHandler<ListPackagingGroupsRequest, ListPackagingGroupsResult> asyncHandler) {
        final ListPackagingGroupsRequest finalRequest = (ListPackagingGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPackagingGroupsResult>(){

            @Override
            public ListPackagingGroupsResult call() throws Exception {
                ListPackagingGroupsResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeListPackagingGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePackagingGroupResult> updatePackagingGroupAsync(UpdatePackagingGroupRequest request) {
        return this.updatePackagingGroupAsync(request, null);
    }

    @Override
    public Future<UpdatePackagingGroupResult> updatePackagingGroupAsync(UpdatePackagingGroupRequest request, final AsyncHandler<UpdatePackagingGroupRequest, UpdatePackagingGroupResult> asyncHandler) {
        final UpdatePackagingGroupRequest finalRequest = (UpdatePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePackagingGroupResult>(){

            @Override
            public UpdatePackagingGroupResult call() throws Exception {
                UpdatePackagingGroupResult result = null;
                try {
                    result = AWSMediaPackageVodAsyncClient.this.executeUpdatePackagingGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

