/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.annotation.SdkInternalApi;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;

@SdkInternalApi
final class PathContainer {
    @JsonProperty(value="InputPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode inputPath;
    @JsonProperty(value="OutputPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode outputPath;
    @JsonProperty(value="ResultPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode resultPath;
    @JsonProperty(value="ItemsPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode itemsPath;
    @JsonProperty(value="Parameters")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode parameters;

    private PathContainer(Builder builder) {
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.resultPath = builder.resultPath;
        this.itemsPath = builder.itemsPath;
        this.parameters = builder.parameters;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.nodeToString(this.inputPath);
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.nodeToString(this.outputPath);
    }

    @JsonIgnore
    public String getResultPath() {
        return this.nodeToString(this.resultPath);
    }

    @JsonIgnore
    public String getItemsPath() {
        return this.nodeToString(this.itemsPath);
    }

    @JsonIgnore
    public JsonNode getParameters() {
        return this.parameters;
    }

    private String nodeToString(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode instanceof NullNode) {
            return null;
        }
        return jsonNode.asText();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class PathSerializer
    extends JsonSerializer<JsonNode> {
        private PathSerializer() {
        }

        public void serialize(JsonNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value instanceof NullNode) {
                gen.writeNull();
            } else if (value != null) {
                gen.writeTree((TreeNode)value);
            }
        }
    }

    public static final class Builder {
        private JsonNode inputPath;
        private JsonNode outputPath;
        private JsonNode resultPath;
        private JsonNode itemsPath;
        private JsonNode parameters;

        protected Builder() {
        }

        @JsonProperty(value="InputPath")
        public Builder inputPath(String inputPath) {
            this.inputPath = this.resolvePath(inputPath);
            return this;
        }

        @JsonProperty(value="OutputPath")
        public Builder outputPath(String outputPath) {
            this.outputPath = this.resolvePath(outputPath);
            return this;
        }

        @JsonProperty(value="ResultPath")
        public Builder resultPath(String resultPath) {
            this.resultPath = this.resolvePath(resultPath);
            return this;
        }

        @JsonProperty(value="ItemsPath")
        public Builder itemsPath(String itemsPath) {
            this.itemsPath = this.resolvePath(itemsPath);
            return this;
        }

        @JsonProperty(value="Parameters")
        public Builder parameters(JsonNode parameters) {
            this.parameters = parameters == null ? NullNode.getInstance() : parameters;
            return this;
        }

        private JsonNode resolvePath(String pathString) {
            if (pathString == null) {
                return NullNode.getInstance();
            }
            return TextNode.valueOf((String)pathString);
        }

        public PathContainer build() {
            return new PathContainer(this);
        }
    }
}

