/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.transcribe.model.Media;

@SdkInternalApi
public class MediaMarshaller {
    private static final MarshallingInfo<String> MEDIAFILEURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaFileUri").build();
    private static final MediaMarshaller instance = new MediaMarshaller();

    public static MediaMarshaller getInstance() {
        return instance;
    }

    public void marshall(Media media, ProtocolMarshaller protocolMarshaller) {
        if (media == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)media.getMediaFileUri(), MEDIAFILEURI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

