/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.util;

import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig;
import java.util.ArrayList;
import java.util.List;

public class BootstrapActions {
    private final String bucket;

    public BootstrapActions() {
        this("us-east-1.elasticmapreduce");
    }

    public BootstrapActions(String bucket) {
        this.bucket = bucket;
    }

    public BootstrapActionConfig newRunIf(String condition, BootstrapActionConfig config) {
        List<String> args = config.getScriptBootstrapAction().getArgs();
        args.add(0, condition);
        args.add(1, config.getScriptBootstrapAction().getPath());
        return new BootstrapActionConfig().withName("Run If, " + config.getName()).withScriptBootstrapAction(new ScriptBootstrapActionConfig().withPath("s3://" + this.bucket + "/bootstrap-actions/run-if").withArgs(args));
    }

    public ConfigureHadoop newConfigureHadoop() {
        return new ConfigureHadoop();
    }

    public ConfigureDaemons newConfigureDaemons() {
        return new ConfigureDaemons();
    }

    public class ConfigureDaemons {
        List<String> args = new ArrayList<String>();
        boolean replace = false;

        private ConfigureDaemons() {
        }

        public ConfigureDaemons withHeapSize(Daemon daemon, int megabytes) {
            this.args.add("--" + daemon.name().toLowerCase() + "-heap-size=" + megabytes);
            return this;
        }

        public ConfigureDaemons withOpts(Daemon daemon, String opts) {
            this.args.add("--" + daemon.name().toLowerCase() + "-opts=\"" + opts + "\"");
            return this;
        }

        public ConfigureDaemons withReplace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public BootstrapActionConfig build() {
            if (this.replace) {
                this.args.add("--replace");
            }
            return new BootstrapActionConfig().withName("Configure Daemons").withScriptBootstrapAction(new ScriptBootstrapActionConfig().withPath("s3://" + BootstrapActions.this.bucket + "/bootstrap-actions/configure-daemons").withArgs(this.args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Daemon {
        NameNode,
        DataNode,
        JobTracker,
        TaskTracker,
        Client;

    }

    public class ConfigureHadoop {
        List<String> args = new ArrayList<String>();

        private ConfigureHadoop() {
        }

        public ConfigureHadoop withXml(ConfigFile file, String xmlPath) {
            String arg = "";
            switch (file) {
                case Site: {
                    arg = "-S";
                    break;
                }
                case Default: {
                    arg = "-D";
                    break;
                }
                case Core: {
                    arg = "-C";
                    break;
                }
                case Hdfs: {
                    arg = "-H";
                    break;
                }
                case Mapred: {
                    arg = "-M";
                }
            }
            this.args.add(arg);
            this.args.add(xmlPath);
            return this;
        }

        public ConfigureHadoop withKeyValue(ConfigFile file, String key, String value) {
            String arg = "";
            switch (file) {
                case Site: {
                    arg = "-s";
                    break;
                }
                case Default: {
                    arg = "-d";
                    break;
                }
                case Core: {
                    arg = "-c";
                    break;
                }
                case Hdfs: {
                    arg = "-h";
                    break;
                }
                case Mapred: {
                    arg = "-m";
                }
            }
            this.args.add(arg);
            this.args.add(key + "=" + value);
            return this;
        }

        public BootstrapActionConfig build() {
            return new BootstrapActionConfig().withName("Configure Hadoop").withScriptBootstrapAction(new ScriptBootstrapActionConfig().withPath("s3://" + BootstrapActions.this.bucket + "/bootstrap-actions/configure-hadoop").withArgs(this.args));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigFile {
        Site,
        Default,
        Core,
        Hdfs,
        Mapred;

    }
}

