/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.deployment;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.ReleaseNamingProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"plan", "name"})
public class DeploymentProperties
implements RootEntityProperties {
    private BambooOidProperties oid;
    private PlanIdentifierProperties plan;
    private String name;
    private String description;
    private ReleaseNamingProperties releaseNaming;
    private List<EnvironmentProperties> environments = new ArrayList<EnvironmentProperties>();
    @SkipCodeGen
    @Nullable
    private final RepositoryStoredSpecsData repositoryStoredSpecsData;

    private DeploymentProperties() {
        this.environments = Collections.emptyList();
        this.releaseNaming = new ReleaseNamingProperties();
        this.repositoryStoredSpecsData = null;
    }

    public DeploymentProperties(@Nullable BambooOidProperties oid, @NotNull PlanIdentifierProperties plan, @NotNull String name, @Nullable String description, @NotNull ReleaseNamingProperties releaseNaming, @NotNull List<EnvironmentProperties> environments, @Nullable RepositoryStoredSpecsData repositoryStoredSpecsData) {
        this.oid = oid;
        this.plan = plan;
        this.name = name;
        this.description = description;
        this.releaseNaming = releaseNaming;
        this.environments = Collections.unmodifiableList(new ArrayList<EnvironmentProperties>(environments));
        this.repositoryStoredSpecsData = repositoryStoredSpecsData;
        this.validate();
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    public PlanIdentifierProperties getPlan() {
        return this.plan;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ReleaseNamingProperties getReleaseNaming() {
        return this.releaseNaming;
    }

    public List<EnvironmentProperties> getEnvironments() {
        return this.environments;
    }

    @Nullable
    public RepositoryStoredSpecsData getRepositoryStoredSpecsData() {
        return this.repositoryStoredSpecsData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentProperties that = (DeploymentProperties)o;
        return Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getPlan(), that.getPlan()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getReleaseNaming(), that.getReleaseNaming()) && Objects.equals(this.getRepositoryStoredSpecsData(), that.getRepositoryStoredSpecsData()) && Objects.equals(this.getEnvironments(), that.getEnvironments());
    }

    public int hashCode() {
        return Objects.hash(this.getOid(), this.getPlan(), this.getName(), this.getDescription(), this.getReleaseNaming(), this.getRepositoryStoredSpecsData(), this.getEnvironments());
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "deployment";
    }

    @Override
    @NotNull
    public String humanReadableId() {
        return String.format("%s %s", "deployment", StringUtils.defaultString((String)this.name, (String)"<unknown>"));
    }

    @Override
    public void validate() {
        ValidationContext context = ValidationContext.of("Deployment");
        ValidationUtils.validateName(context, this.name);
        ImporterUtils.checkRequired(context.with("plan"), this.plan);
        ImporterUtils.checkRequired(context.with("releaseNaming"), this.releaseNaming);
        HashSet<String> environmentNames = new HashSet<String>();
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        for (EnvironmentProperties env : this.environments) {
            if (environmentNames.contains(env.getName())) {
                errors.add(new ValidationProblem("Duplicate environment name " + env.getName()));
            }
            environmentNames.add(env.getName());
        }
        ImporterUtils.checkNoErrors(errors);
    }
}

