/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public class FixedAmqpRetryPolicy
extends AmqpRetryPolicy {
    public FixedAmqpRetryPolicy(AmqpRetryOptions retryOptions) {
        super(retryOptions);
    }

    @Override
    protected Duration calculateRetryDelay(int retryCount, Duration baseDelay, Duration baseJitter, ThreadLocalRandom random) {
        Double jitterNanos = random.nextDouble() * (double)baseJitter.getSeconds() * 1.0E9;
        Duration jitter = Duration.ofNanos(jitterNanos.longValue());
        return baseDelay.plus(jitter);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof FixedAmqpRetryPolicy && super.equals(obj);
    }
}

