/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.exception;

import com.azure.core.amqp.exception.SessionErrorContext;
import java.util.Locale;

public class LinkErrorContext
extends SessionErrorContext {
    private static final long serialVersionUID = 2581371351997722504L;
    private final String trackingId;
    private final Integer linkCredit;

    public LinkErrorContext(String namespace, String entityPath, String trackingId, Integer linkCredit) {
        super(namespace, entityPath);
        this.trackingId = trackingId;
        this.linkCredit = linkCredit;
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public Integer getLinkCredit() {
        return this.linkCredit;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        if (this.getTrackingId() != null) {
            builder.append(", ");
            builder.append(String.format(Locale.US, "REFERENCE_ID: %s", this.getTrackingId()));
        }
        if (this.getLinkCredit() != null) {
            builder.append(", ");
            builder.append(String.format(Locale.US, "LINK_CREDIT: %s", this.getLinkCredit()));
        }
        return builder.toString();
    }
}

