/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.okhttp.implementation.OkHttpStreamableRequestBody;
import com.azure.core.implementation.util.FileContent;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import okhttp3.MediaType;
import okio.BufferedSink;

public class OkHttpFileRequestBody
extends OkHttpStreamableRequestBody<FileContent> {
    public OkHttpFileRequestBody(FileContent content, long effectiveContentLength, MediaType mediaType) {
        super(content, effectiveContentLength, mediaType);
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        try (FileChannel channel = FileChannel.open(((FileContent)this.content).getFile(), StandardOpenOption.READ);){
            long transferred;
            long pendingTransfer = ((FileContent)this.content).getLength();
            long position = ((FileContent)this.content).getPosition();
            do {
                if ((transferred = channel.transferTo(position, pendingTransfer, (WritableByteChannel)bufferedSink)) < 0L) {
                    break;
                }
                position += transferred;
            } while ((pendingTransfer -= transferred) > 0L);
        }
    }
}

